package com.bcxin.sync.service.tenant;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.common.utils.IdGeneratorSnowflake;
import com.bcxin.sync.dao.mapper.tenant.RbacPermitAppRoleMapper;
import com.bcxin.sync.entity.tenant.RbacPermitAppRoleEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * description：智能人事-权限应用角色关联表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class RbacPermitAppRoleService extends ServiceImpl<RbacPermitAppRoleMapper, RbacPermitAppRoleEntity> {

    @Autowired
    private IdGeneratorSnowflake snowflake;

    /**
     * description：判断应用和角色是否关联
     * author：linchunpeng
     * date：2025/2/26
     */
    public boolean isExistApp(Long permitAppId, Long rbacRoleId) {
        LambdaQueryChainWrapper<RbacPermitAppRoleEntity> lqw = this.lambdaQuery();
        lqw.eq(RbacPermitAppRoleEntity::getPermitAppId, permitAppId);
        lqw.eq(RbacPermitAppRoleEntity::getRbacRoleId, rbacRoleId);
        return lqw.exists();
    }

    public RbacPermitAppRoleEntity create(String organizationId, Long permitAppId, Long roleId, String appCode, Integer permitType) {
        RbacPermitAppRoleEntity appRoleEntity = new RbacPermitAppRoleEntity();
        appRoleEntity.setId(snowflake.snowflakeId());
        appRoleEntity.setOrganizationId(organizationId);
        appRoleEntity.setPermitAppId(permitAppId);
        appRoleEntity.setRbacRoleId(roleId);
        appRoleEntity.setAppCode(appCode);
        appRoleEntity.setPermitType(permitType);
        appRoleEntity.setCreateTime(new Date());
        return appRoleEntity;
    }

}