package com.bcxin.sync.service.jvs;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.jvs.SysRoleMapper;
import com.bcxin.sync.entity.jvs.SysRoleEntity;
import com.bcxin.sync.entity.jvs.SysRolePermissionEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * description：jvs-角色表
 * author：linchunpeng
 * date：2025/2/10
 */
@Slf4j
@Service
public class SysRoleService extends ServiceImpl<SysRoleMapper, SysRoleEntity> {

    @Autowired
    private SysRolePermissionService sysRolePermissionService;

    private final static String INIT_PERMISSION = "325,327";

    /**
     * description：初始化知识库的基础角色和权限
     * author：linchunpeng
     * date：2025/2/12
     */
    @Transactional
    public String initDocumentRoleAndPermission(String ordId) {
        StringBuffer syncResult = new StringBuffer(64);
        LambdaQueryChainWrapper<SysRoleEntity> lqw = this.lambdaQuery();
        lqw.eq(SysRoleEntity::getRoleName, "知识库基本角色");
        lqw.eq(SysRoleEntity::getTenantId, ordId);
        List<SysRoleEntity> list = lqw.list();
        if (CollectionUtil.isEmpty(list)) {
            //不存在，新增一个角色
            SysRoleEntity entity = new SysRoleEntity();
            entity.setId(UUID.randomUUID().toString());
            entity.setRoleName("知识库基本角色");
            entity.setRoleDesc("知识库基本角色");
            entity.setTenantId(ordId);
            this.save(entity);
            syncResult.append("\n初始化知识库的基础角色成功");
            //新增角色权限
            List<SysRolePermissionEntity> sysRolePermissionEntityList = new ArrayList<>();
            for (String permissionId : INIT_PERMISSION.split(",")) {
                SysRolePermissionEntity sysRolePermissionEntity = new SysRolePermissionEntity();
                sysRolePermissionEntity.setRoleId(entity.getId());
                sysRolePermissionEntity.setPermissionId(permissionId);
                sysRolePermissionEntity.setTenantId(ordId);
                sysRolePermissionEntityList.add(sysRolePermissionEntity);
            }
            syncResult.append("\n初始化知识库的基础权限成功");
            sysRolePermissionService.saveBatch(sysRolePermissionEntityList);
        }
        return syncResult.toString();
    }

}