package com.bcxin.sync.service;

import com.bcxin.sync.common.exception.GetResponseException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

@Slf4j
@Service
public class LoginService {

    @Autowired
    private AuthenticationManager authenticationManager;

    /**
     * description：自定义登录-通职员id
     * author：linchunpeng
     * date：2025/2/24
     */
    public boolean loginByEmployeeId(String empId, HttpServletRequest httpRequest) {
        // 调用Authentication的authenticate方法进行认证
        Authentication authentication = null;
        try {
            UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken(empId, empId);
            authentication = authenticationManager.authenticate(authenticationToken);
            SecurityContext securityContext = SecurityContextHolder.getContext();
            securityContext.setAuthentication(authentication);
            HttpSession session = httpRequest.getSession(true);  // 创建新 Session
            session.setAttribute("SPRING_SECURITY_CONTEXT", securityContext);
        } catch (Exception e) {
            if (e instanceof BadCredentialsException){
                // 密码错误 认证失败
                throw new GetResponseException(403, "页面禁止访问..");
            } else {
                throw new GetResponseException(500, e.getMessage());
            }
        }
        // 如果认证未通过，返回错误信息
        if (authentication == null) {
            throw new GetResponseException(401, "页面未授权.");
        }
        return true;
    }

}
