package com.bcxin.sync.entity.tenant;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * description：智能人事-驻勤点表
 * author：linchunpeng
 * date：2024/12/31
 */
@Data
@TableName(value = "tlk_attendance_site_base_info", schema = "baibaodunflow")
public class TlkAttendanceSiteBaseInfoEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    //主键id
    @TableId(value = "ID")
    private String id;

    //组织id
    @TableField(value = "domainid")
    private String domainid;

    //驻勤点名称
    @TableField(value = "ITEM_attendanceSiteName")
    private String itemAttendanceSiteName;

    //驻勤点详细地址
    @TableField(value = "ITEM_attendanceSiteFullAddress")
    private String itemAttendanceSiteFullAddress;

    //驻勤点经度
    @TableField(value = "ITEM_attendanceSiteLongitude")
    private BigDecimal itemAttendanceSiteLongitude;

    //驻勤点纬度
    @TableField(value = "ITEM_attendanceSiteLatitude")
    private BigDecimal itemAttendanceSiteLatitude;

    //执行范围
    @TableField(value = "ITEM_performRange")
    private BigDecimal itemPerformRange;

    //驻勤点状态,已完善
    @TableField(value = "ITEM_attendanceSiteState")
    private String itemAttendanceSiteState;

    //驻勤开始日期
    @TableField(value = "ITEM_attendanceStartDate")
    private Date itemAttendanceStartDate;

    //驻勤结束日期
    @TableField(value = "ITEM_attendanceEndDate")
    private Date itemAttendanceEndDate;

    //负责人，职员id
    @TableField(value = "ITEM_principal")
    private String itemPrincipal;

    //是否删除
    @TableField(value = "ITEM_isdeleted")
    private String itemIsdeleted;

    //驻勤点类型，0或空：常驻，其他：临保
    @TableField(value = "ITEM_ATT_TYPE")
    private String itemAttType;


}