package com.bcxin.sync.dtos.response;

import cn.hutool.core.date.DateUtil;
import lombok.Data;

import java.util.Date;


@Data
public class BindDeviceResponse {

    //设备编号
    private String deviceNo;
    //设备名称
    private String deviceName;
    //设备类型，4-代表着华为云台摄像机
    private Integer deviceType;
    //绑定类型，0-驻勤点；1-考场
    private Integer bindType;
    //绑定数据源id
    private String bindPlaceId;
    //绑定数据源
    private String bindPlace;
    //绑定数据源所属的组织id
    private String bindOrgId;
    //绑定数据源所属组织的监管机构id
    private String bindSupDepartId;
    //考试开始时间
    private Date startTime;
    //考试结束时间
    private Date endTime;

    public Date getStartTime() {
        if (startTime != null) {
            return DateUtil.offsetMinute(startTime,-5);
        }
        return startTime;
    }

    public Date getEndTime() {
        if (endTime != null) {
            return DateUtil.offsetMinute(endTime,5);
        }
        return endTime;
    }
}
