package com.bcxin.sync.controller;


import com.bcxin.sync.dtos.request.*;
import com.bcxin.sync.dtos.response.result.RespResult;
import com.bcxin.sync.service.tenant.RbacCustomRoleService;
import com.bcxin.sync.service.DataSyncToTljService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * description：同步陀螺匠接口
 * author：linchunpeng
 * date：2025/2/11
 */
@Slf4j
@RestController
public class SyncToTljController {


    @Autowired
    private DataSyncToTljService dataSyncToTljService;
    @Autowired
    private RbacCustomRoleService rbacCustomRoleService;

    /**
     * 初始化"普通员工"角色
     */
    @PostMapping("/api/tlj/init/normal/role")
    public RespResult<String> initNormalRole(@RequestBody @Validated OrganizationSyncRequest request) {
        rbacCustomRoleService.initRole(request.getOrganizationId());
        return RespResult.successful("初始化成功");
    }

    /**
     * 初始化用户权限(升级高级版之前的权限同步到高级版)
     */
    @PostMapping("/api/tlj/init/user/permit")
    public RespResult<String> initUserPermit(@RequestBody @Validated OrganizationSyncRequest request) {
        rbacCustomRoleService.initUserPermit(request.getOrganizationId());
        return RespResult.successful("初始化成功");
    }

    /**
     * 初始化OA审批目标
     */
    @PostMapping("/api/tlj/init/oa/temp")
    public RespResult<String> initOaTemp(@RequestBody @Validated OrganizationSyncRequest request) {
        dataSyncToTljService.initOaTemp(request);
        return RespResult.successful("初始化成功");
    }

    /**
     * 同步消息通知模版
     */
    @PostMapping("/api/tlj/sync/message/template")
    public RespResult<String> syncMessageNoticeTemplate(@RequestBody @Validated MessageNoticeSyncRequest request) {
        dataSyncToTljService.syncMessageNoticeTemplate(request.getEmployeeId(), request.getOrganizationId());
        return RespResult.successful("同步成功");
    }

    /**
     * 开通陀螺匠
     */
    @PostMapping("/api/tlj/sync")
    public RespResult<String> sync(@RequestBody @Validated OrganizationSyncRequest request) {
        return RespResult.successful(dataSyncToTljService.sync(request.getOrganizationId()));
    }

    /**
     * 同步用户
     */
    @PostMapping("/api/tlj/sync/user")
    public RespResult<String> syncUser(@RequestBody @Validated UserSyncRequest request) {
        dataSyncToTljService.syncUser(request);
        return RespResult.successful("同步成功");
    }

    /**
     * 同步部门
     */
    @PostMapping("/api/tlj/sync/department")
    public RespResult<String> syncDepartment(@RequestBody @Validated DepartmentSyncRequest request) {
        dataSyncToTljService.syncDepartment(request);
        return RespResult.successful("同步成功");
    }

    /**
     * 同步员工
     */
    @PostMapping("/api/tlj/sync/employee")
    public RespResult<String> syncEmployee(@RequestBody @Validated EmployeeSyncRequest request) {
        dataSyncToTljService.syncEmployee(request);
        return RespResult.successful("同步成功");
    }

    /**
     * 同步驻勤点和人员
     */
    @PostMapping("/api/tlj/sync/attendance/site")
    public RespResult<String> syncAttendanceSite(@RequestBody AttendanceSiteSyncRequest request) {
        dataSyncToTljService.syncAttendanceSite(request);
        return RespResult.successful("同步驻勤点和人员成功");
    }


    /**
     * 同步活动承办方（通过项目）
     */
    @PostMapping("/api/tlj/sync/domain/by/project")
    public RespResult<String> tljSyncDomainByProject(@RequestBody OrganizationListSyncRequest request) {
        for (String orgId : request.getOrganizationIdList()) {
            dataSyncToTljService.tljSyncDomainByProject(orgId);
        }
        return RespResult.successful("同步成功");
    }

    /**
     * 同步活动承办方（通过团队）
     */
    @PostMapping("/api/tlj/sync/domain/by/team")
    public RespResult<String> tljSyncDomainByTeam(@RequestBody OrganizationListSyncRequest request) {
        for (String orgId : request.getOrganizationIdList()) {
            dataSyncToTljService.tljSyncDomainByTeam(orgId);
        }
        return RespResult.successful("同步成功");
    }

}
