package com.bcxin.sync.controller;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.dtos.request.OrganizationOpenRequest;
import com.bcxin.sync.dtos.response.result.RespResult;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
public class OpenController {


    @Autowired
    private OrganizationOpenService organizationOpenService;

    /**
     * 企业开通第三方系统
     */
    @PostMapping("/api/open/third")
    public RespResult<String> openThird(@RequestBody @Validated OrganizationOpenRequest request) {
        log.info("企业开通第三方系统：{}", JSONObject.toJSONString(request));
        organizationOpenService.openThird(request);
        return RespResult.successful("开通成功");
    }

}
