package com.bcxin.sync.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.utils.AssertUtils;
import com.bcxin.sync.dtos.page.TableDataInfo;
import com.bcxin.sync.dtos.request.DeviceRecordListRequest;
import com.bcxin.sync.dtos.request.LongIdRequest;
import com.bcxin.sync.dtos.response.result.RespResult;
import com.bcxin.sync.entity.tenant.DeviceRecordEntity;
import com.bcxin.sync.service.tenant.DeviceRecordService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 设备录像表接口
 */
@Slf4j
@Api(tags = "设备录像表接口")
@RestController
public class DeviceRecordController {

    @Autowired
    private DeviceRecordService deviceRecordService;

    @ApiOperation(value = "获取设备录像列表")
    @ApiImplicitParam(name = "Accesstoken（v5职员的token）", required = true, paramType = "header",dataType = "String")
    @PostMapping("/api/device/record/list")
    public TableDataInfo<DeviceRecordEntity> list(@RequestBody DeviceRecordListRequest request) {
        log.info("获取设备录像列表，参数：{}", JSONObject.toJSONString(request));
        AssertUtils.isTrue(CollectionUtil.isNotEmpty(request.getOrgIdList())
                || CollectionUtil.isNotEmpty(request.getSupDepartIdList()), "查询条件：组织id列表 或者 监管机构id列表不能同时为空");

        List<DeviceRecordEntity> list = deviceRecordService.getList(request);
        return new TableDataInfo<>(list, new PageInfo<>(list).getTotal());
    }


    @ApiOperation(value = "手动触发下载视频流")
    @ApiImplicitParam(name = "Accesstoken（v5职员的token）", required = true, paramType = "header",dataType = "String")
    @PostMapping("/api/device/record/download/file")
    public RespResult downloadFile(@RequestBody LongIdRequest request) {
        log.info("手动触发下载视频流，参数：{}", JSONObject.toJSONString(request));
        DeviceRecordEntity entity = deviceRecordService.getById(request.getId());
        deviceRecordService.startDownload(entity);
        return RespResult.successful("手动触发成功");
    }
}
