package com.bcxin.sync.consumer;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.TenantOrganizationsSyncMessage;
import com.bcxin.sync.dtos.kafka.message.TlkEventTeamSyncMessage;
import com.bcxin.sync.dtos.request.OrganizationOpenRequest;
import com.bcxin.sync.service.RedisCache;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tenant.RbacCustomRoleService;
import com.bcxin.sync.service.tenant.TlkEventProjectService;
import com.bcxin.sync.service.tenant.TlkEventTeamService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * 团队kafka消息监听器
 */
@Slf4j
@Service
public class TlkEventTeamKafkaConsumer {

    @Autowired
    private OrganizationOpenService organizationOpenService;

    @Autowired
    private TlkEventTeamService tlkEventTeamService;

    @KafkaListener(id = "bcx_data_sync_listener_tlk_event_team",
            topics = CommonConstant.TLK_EVENT_TEAM_KAFKA_TOPIC,
            groupId = "bcx_data_sync_tlk_event_team")
    public void bcxDataSyncTlkEventTeam(ConsumerRecord<String, String> record, Acknowledgment ack) {
        TlkEventTeamSyncMessage team = KafkaMessageUtil.transferKafkaTlkEventTeamRecord2Message(record);
        log.info("kafka监听tlk_event_team表，数据转化为：{}", JSONObject.toJSONString(team));
        try {
            if (team != null) {
                //开通陀螺匠
                Date now = new Date();
                Date endTime = tlkEventTeamService.getEndTimeByTeamId(team.getTeamId(), now);
                if (endTime.after(now)) {
                    OrganizationOpenRequest request = new OrganizationOpenRequest();
                    request.setOrganizationId(team.getTeamId());
                    request.setOrganizationName(team.getTeamName());
                    request.setOpenType(1);
                    request.setEndTime(endTime);
                    request.setOpenDay((int) DateUtil.between(now, endTime, DateUnit.DAY));
                    organizationOpenService.openThird(request);
                } else {
                    log.info("结束时间<=当前时间，无需同步");
                }
            } else {
                log.info("不是新增团队参与项目，无需同步");
            }
        } catch (Exception e) {
            log.error("kafka监听tlk_event_team表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
