package com.bcxin.sync.consumer;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.emus.OpenType;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.RbacPermitOptionUserSyncMessage;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tenant.RbacPermitOptionUserService;
import com.bcxin.sync.service.tenant.TenantOrganizationsService;
import com.bcxin.sync.service.tuoluojiang.EbAdminService;
import com.bcxin.sync.service.tuoluojiang.EbAttendanceWhitelistService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

/**
 * 权限操作项用户关联表kafka监听器
 */
@Component
@Slf4j
public class RbacPermitOptionUserKafkaConsumer {

    @Autowired
    private EbAdminService ebAdminService;
    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private EbAttendanceWhitelistService ebAttendanceWhitelistService;
    @Autowired
    private OrganizationOpenService organizationOpenService;
    @Autowired
    private RbacPermitOptionUserService rbacPermitOptionUserService;
    @Autowired
    private TenantOrganizationsService tenantOrganizationsService;


    @KafkaListener(id = "bcx_data_sync_listener_rbac_permit_option_user_to_tlj",
            topics = CommonConstant.RBAC_PERMIT_OPTION_USER_KAFKA_TOPIC,
            groupId = "bcx_data_sync_rbac_permit_option_user_to_tlj")
    public void bcxDataSyncRbacPermitOptionUserToTlj(ConsumerRecord<String, String> record, Acknowledgment ack) {
        RbacPermitOptionUserSyncMessage rbacPermitOptionUser = KafkaMessageUtil.transferKafkaRbacPermitOptionUser2Message(record);
        log.info("kafka监听rbac_permit_option_user表，数据转化为：{}", JSONObject.toJSONString(rbacPermitOptionUser));
        try {
            if (CommonConstant.NEED_SYNC_PERMIT_CODES.contains(rbacPermitOptionUser.getOptionCode())) {
                log.info("权限{},是需要同步的", rbacPermitOptionUser.getOptionCode());
                boolean openAndEffective = organizationOpenService.isOpenAndEffective(rbacPermitOptionUser.getOrganizationId(), OpenType.TLJ.getCode());
                Integer leve = tenantOrganizationsService.getLevelByOrgId(rbacPermitOptionUser.getOrganizationId());
                if (openAndEffective && leve == 2) {
                    Long entid = ebEnterpriseService.getIdByOrgId(rbacPermitOptionUser.getOrganizationId());
                    if (entid != null) {
                        log.info("组织id：{}，有开通陀螺匠，所以需要同步权限信息", rbacPermitOptionUser.getOrganizationId());
                        //是否存在关联关系
                        boolean existPermit = rbacPermitOptionUserService.isExistPermit(rbacPermitOptionUser.getTenantEmployeeId(), rbacPermitOptionUser.getPermitOptionId());
                        Long adminId = ebAdminService.getIdByEmployeeId(rbacPermitOptionUser.getTenantEmployeeId(), entid);
                        if (adminId != null) {
                            if (existPermit) {
                                //存在关联关系，即表示新增权限
                                if (CommonConstant.ATTENDANCE_MANAGER_CODE.equals(rbacPermitOptionUser.getOptionCode())) {
                                    log.info("组织id：{}，职员id：{}，新增考勤管理员权限信息", rbacPermitOptionUser.getOrganizationId(), rbacPermitOptionUser.getTenantEmployeeId());
                                    ebAttendanceWhitelistService.attendanceWhitelistCreate(entid, adminId, 1);
                                }
                            } else {
                                //不存在关联关系，即表示删除权限
                                if (CommonConstant.ATTENDANCE_MANAGER_CODE.equals(rbacPermitOptionUser.getOptionCode())) {
                                    log.info("组织id：{}，职员id：{}，删除考勤管理员权限信息", rbacPermitOptionUser.getOrganizationId(), rbacPermitOptionUser.getTenantEmployeeId());
                                    ebAttendanceWhitelistService.attendanceWhitelistDelete(adminId, 1);
                                }
                            }
                        }
                    }
                } else {
                    log.info("组织id：{}，没开通陀螺匠，所以不需要同步权限信息", rbacPermitOptionUser.getOrganizationId());
                }
            } else {
                log.info("权限{},是不需要同步的", rbacPermitOptionUser.getOptionCode());
            }
        } catch (Exception e) {
            log.error("kafka监听rbac_permit_option_user表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
