package com.bcxin.sync.consumer;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.emus.DataOperationType;
import com.bcxin.sync.common.emus.OpenType;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.ExternalGroupSyncMessage;
import com.bcxin.sync.entity.tenant.TenantDepartmentsEntity;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tenant.TenantDepartmentsService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseService;
import com.bcxin.sync.service.tuoluojiang.EbFrameService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Service;

/**
 * 分组kafka消息监听器
 */
@Slf4j
@Service
public class ExternalGroupKafkaConsumer {

    @Autowired
    private TenantDepartmentsService tenantDepartmentsService;
    @Autowired
    private EbFrameService ebFrameService;
    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private OrganizationOpenService organizationOpenService;

    @KafkaListener(id = "bcx_data_sync_listener_external_groups_to_tlj",
            topics = CommonConstant.EXTERNAL_GROUPS_KAFKA_TOPIC,
            groupId = "bcx_data_sync_external_groups_to_tlj")
    public void bcxDataSyncExternalGroupsToTlj(ConsumerRecord<String, String> record, Acknowledgment ack) {
        ExternalGroupSyncMessage group = KafkaMessageUtil.transferKafkaGroupRecord2Message(record);
        log.info("kafka监听external_groups表，数据转化为：{}", JSONObject.toJSONString(group));
        try {
            if (group.getReferenceType() == 0) {
                boolean openAndEffective = organizationOpenService.isOpenAndEffective(group.getReferenceNumber(), OpenType.TLJ.getCode());
                if (openAndEffective) {
                    Long entid = ebEnterpriseService.getIdByOrgId(group.getReferenceNumber());
                    if (entid != null) {
                        //有开通陀螺匠，才需要同步分组信息
                        log.info("组织id：{}，有开通陀螺匠，所以需要同步分组信息", group.getReferenceNumber());
                        if (group.getType().getCode() == DataOperationType.DELETE.getCode()) {
                            //删除
                            log.info("组织id：{}，删除分组", group.getReferenceNumber());
                            ebFrameService.frameDelete(group.getGroupId(), group.getAfterGroupName());
                        } else {
                            log.info("组织id：{}，新增或修改分组", group.getReferenceNumber());
                            Long pid = null;
                            if (StringUtils.isNotBlank(group.getAfterParentId())) {
                                pid = ebFrameService.getIdByDepartmentId(group.getAfterParentId());
                            } else {
                                pid = ebFrameService.getIdByDepartmentId(tenantDepartmentsService.getRootDeptByOrganizationId(group.getReferenceNumber()).getId());
                            }
                            ebFrameService.frameCreate(entid, group.getGroupId(), group.getAfterGroupName(), pid);
                        }
                    }
                } else {
                    log.info("组织id：{}，没开通陀螺匠，所以不需要同步分组信息", group.getReferenceNumber());
                }
            }
        } catch (Exception e) {
            log.error("kafka监听external_groups表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
