package com.bcxin.sync.consumer;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.emus.DataOperationType;
import com.bcxin.sync.common.emus.OpenType;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.EmployeeSyncMessage;
import com.bcxin.sync.dtos.response.BcxDepartmentResponse;
import com.bcxin.sync.dtos.response.BcxEmployeeResponse;
import com.bcxin.sync.entity.jvs.SysTenantEntity;
import com.bcxin.sync.entity.jvs.SysUserInfoEntity;
import com.bcxin.sync.entity.tenant.TenantDepartmentEmployeeRelationsEntity;
import com.bcxin.sync.entity.tuoluojiang.EbUserEntity;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tenant.*;
import com.bcxin.sync.service.jvs.SysTenantService;
import com.bcxin.sync.service.jvs.SysUserInfoService;
import com.bcxin.sync.service.jvs.SysUserTenantService;
import com.bcxin.sync.service.tenant.TenantDepartmentEmployeeRelationsService;
import com.bcxin.sync.service.tenant.TenantDepartmentsService;
import com.bcxin.sync.service.tenant.TenantEmployeesService;
import com.bcxin.sync.service.tuoluojiang.EbAdminService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseRoleService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseService;
import com.bcxin.sync.service.tuoluojiang.EbUserService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 职员kafka消息监听器
 */
@Slf4j
@Component
public class EmployeeKafkaConsumer {

    @Autowired
    private EbUserService ebUserService;
    @Autowired
    private EbAdminService ebAdminService;
    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private EbEnterpriseRoleService ebEnterpriseRoleService;
    @Autowired
    private TenantOrganizationsService tenantOrganizationsService;
    @Autowired
    private SysUserInfoService sysUserInfoService;
    @Autowired
    private SysUserTenantService sysUserTenantService;
    @Autowired
    private SysTenantService sysTenantService;
    @Autowired
    private TenantEmployeesService tenantEmployeesService;
    @Autowired
    private TenantDepartmentEmployeeRelationsService tenantDepartmentEmployeeRelationsService;
    @Autowired
    private RbacCustomRoleService rbacCustomRoleService;
    @Autowired
    private RbacCustomRoleUserService rbacCustomRoleUserService;
    @Autowired
    private TenantDepartmentsService tenantDepartmentsService;
    @Autowired
    private OrganizationOpenService organizationOpenService;

    @KafkaListener(id = "bcx_data_sync_listener_tenant_employee_to_tlj",
            topics = CommonConstant.EMPLOYEE_KAFKA_TOPIC,
            groupId = "bcx_data_sync_employee_to_tlj")
    public void bcxDataSyncEmployeeToTlj(ConsumerRecord<String, String> record, Acknowledgment ack) {
        EmployeeSyncMessage employee = KafkaMessageUtil.transferKafkaEmployeeRecord2Message(record);
        log.info("同步陀螺匠，kafka监听tenant-employee表，数据转化为：{}", JSONObject.toJSONString(employee));
        try {
            if (employee != null) {
                boolean openAndEffective = organizationOpenService.isOpenAndEffective(employee.getOrganizationId(), OpenType.TLJ.getCode());
                if (openAndEffective) {
                    Long entid = ebEnterpriseService.getIdByOrgId(employee.getOrganizationId());
                    if (entid != null) {
                        //有开通陀螺匠，才需要同步职员信息
                        log.info("同步陀螺匠，组织id：{}，有开通陀螺匠，所以需要同步职员信息", employee.getOrganizationId());
                        List<BcxEmployeeResponse> employeeResponseList = tenantEmployeesService.getEmployeeResponseListByEmployeeIdList(Collections.singletonList(employee.getEmployeeId()), null);
                        EbUserEntity ebUserEntity = ebUserService.getUserByUserId(employee.getUserId());
                        if (ebUserEntity == null) {
                            log.info("同步陀螺匠，职员id：{}，还未同步过陀螺匠，所以需要同步用户信息", employee.getEmployeeId());
                            ebUserService.userCreate(employee.getUserId(), employeeResponseList.get(0).getCredentialNumber(),
                                    employeeResponseList.get(0).getCardPhoto(), employeeResponseList.get(0).getHeadPhoto(),
                                    employeeResponseList.get(0).getEmployeeName(), employeeResponseList.get(0).getTelephone());
                        }
                        Long oaAndAttendanceRoleId = ebEnterpriseRoleService.createGetOaAndAttendanceRole(entid);
                        List<TenantDepartmentEmployeeRelationsEntity> departmentEmployeeRelationsEntityList = tenantDepartmentEmployeeRelationsService.getListByEmployeeIdList(Collections.singletonList(employee.getEmployeeId()));
                        ebAdminService.userJoin(employee.getOrganizationId(), entid, employee.getUserId(), employee.getEmployeeId(),
                                departmentEmployeeRelationsEntityList, employee, null);
                        //同步员工其他信息
                        ebAdminService.setAdminOtherInfo(employee.getEmployeeId(), oaAndAttendanceRoleId,
                                employeeResponseList.get(0).getCardPhoto(), employee, employee.getAfterIsDomainAdmin(), 0);
                    }
                } else {
                    log.info("同步陀螺匠，组织id：{}，没有开通陀螺匠，所以不需要同步职员信息", employee.getOrganizationId());
                }
            }
        } catch (Exception e) {
            log.error("同步陀螺匠，kafka监听tenant-employee表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }


    @KafkaListener(id = "bcx_data_sync_listener_tenant_employee_to_rbac",
            topics = CommonConstant.EMPLOYEE_KAFKA_TOPIC,
            groupId = "bcx_data_sync_employee_to_rbac")
    public void bcxDataSyncEmployeeToRbac(ConsumerRecord<String, String> record, Acknowledgment ack) {
        EmployeeSyncMessage employee = KafkaMessageUtil.transferKafkaEmployeeRecord2Message(record);
        log.info("同步rbac，kafka监听tenant-employee表，数据转化为：{}", JSONObject.toJSONString(employee));
        try {
            if (employee != null) {
                Integer leve = tenantOrganizationsService.getLevelByOrgId(employee.getOrganizationId());
                if (leve == 2) {
                    log.info("同步rbac，组织id：{}，有开通高级版，所以需要同步职员信息到rbac基础角色", employee.getOrganizationId());
                    Long roleId = rbacCustomRoleService.getPTYGRoleIdByOrganizationId(employee.getOrganizationId());
                    //在离职状态变化
                    if (employee.getOpType().getCode() == DataOperationType.CREATE.getCode()) {
                        //新入职
                        rbacCustomRoleUserService.createAndSave(employee.getOrganizationId(), roleId, employee.getEmployeeId());
                    } else if (employee.getBeforeStatus().getCode() == 0 && employee.getAfterStatus().getCode() == 1) {
                        //离职
                        rbacCustomRoleUserService.deleteByRoleIdAndEmployeeId(roleId, employee.getEmployeeId());
                    } else if (employee.getBeforeStatus().getCode() == 1 && employee.getAfterStatus().getCode() == 0) {
                        //复职
                        rbacCustomRoleUserService.createAndSave(employee.getOrganizationId(), roleId, employee.getEmployeeId());
                    }
                } else {
                    log.info("同步rbac，组织id：{}，没有开通高级版，所以不需要同步职员信息到rbac基础角色", employee.getOrganizationId());
                }
            }
        } catch (Exception e) {
            log.error("同步rbac，kafka监听tenant-employee表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }

    @KafkaListener(id = "bcx_data_sync_listener_tenant_employee_to_jvs",
            topics = CommonConstant.EMPLOYEE_KAFKA_TOPIC,
            groupId = "bcx_data_sync_employee_to_jvs")
    public void bcxDataSyncEmployeeToJvs(ConsumerRecord<String, String> record, Acknowledgment ack) {
        EmployeeSyncMessage employee = KafkaMessageUtil.transferKafkaEmployeeRecord2Message(record);
        log.info("同步JVS，kafka监听tenant-employee表，数据转化为：{}", JSONObject.toJSONString(employee));
        try {
            if (employee != null) {
                boolean openAndEffective = organizationOpenService.isOpenAndEffective(employee.getOrganizationId(), OpenType.JVS.getCode());
                if (openAndEffective) {
                    SysTenantEntity sysTenant = sysTenantService.getById(employee.getOrganizationId());
                    if (sysTenant != null) {
                        //有开通JVS，才需要同步职员信息
                        log.info("同步JVS，组织id：{}，有开JVS，所以需要同步职员信息", employee.getOrganizationId());
                        List<BcxEmployeeResponse> employeeResponseList = tenantEmployeesService.getEmployeeResponseListByEmployeeIdList(Collections.singletonList(employee.getEmployeeId()), null);
                        BcxEmployeeResponse employeeResponse = employeeResponseList.get(0);
                        SysUserInfoEntity sysUserInfo = sysUserInfoService.getById(employee.getUserId());
                        if (sysUserInfo == null) {
                            log.info("同步JVS，职员id：{}，还未同步过JVS，所以需要同步用户信息", employee.getEmployeeId());
                            sysUserInfoService.create(employee.getUserId(), employeeResponse.getCredentialNumber(), employeeResponse.getEmployeeName(), employeeResponse.getTelephone());
                        }
                        //查询部门-员工关联关系列表
                        List<TenantDepartmentEmployeeRelationsEntity> departmentEmployeeRelationsEntityList = tenantDepartmentEmployeeRelationsService.getListByEmployeeIdList(Collections.singletonList(employee.getEmployeeId()));
                        Map<String, List<TenantDepartmentEmployeeRelationsEntity>> employeeDepartmentMap = departmentEmployeeRelationsEntityList.stream().collect(Collectors.groupingBy(TenantDepartmentEmployeeRelationsEntity::getEmployeeId));
                        List<String> departmentIdList = departmentEmployeeRelationsEntityList.stream().map(TenantDepartmentEmployeeRelationsEntity::getDepartmentId).collect(Collectors.toList());
                        List<BcxDepartmentResponse> departmentResponseList = tenantDepartmentsService.getDepartmentResponseListByOrganizationId(employee.getOrganizationId(), departmentIdList);
                        Map<String, String> deptMap = departmentResponseList.stream().collect(Collectors.toMap(BcxDepartmentResponse::getId, BcxDepartmentResponse::getDepartmentName));

                        sysUserTenantService.createAndSave(sysTenant.getId(), employee.getUserId(), employee.getEmployeeId(),
                                employeeResponse.getEmployeeName(), employeeResponse.getTelephone(), employeeResponse.getHiredDate(),
                                employeeDepartmentMap.get(employeeResponse.getId()), deptMap, employee);
                    }
                } else {
                    log.info("同步JVS，组织id：{}，没有开通JVS，所以不需要同步职员信息", employee.getOrganizationId());
                }
            }
        } catch (Exception e) {
            log.error("同步JVS，kafka监听tenant-employee表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
