package com.bcxin.sync.consumer;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.emus.DataOperationType;
import com.bcxin.sync.common.emus.OpenType;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.AttendanceSiteSyncMessage;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tuoluojiang.EbAttendanceGroupService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Date;

/**
 * 驻勤点kafka监听器
 */
@Slf4j
@Component
public class AttendanceSiteKafkaConsumer {

    @Autowired
    private EbAttendanceGroupService ebAttendanceGroupService;
    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private OrganizationOpenService organizationOpenService;

    @KafkaListener(id = "bcx_data_sync_listener_attendance_site_to_tlj",
            topics = CommonConstant.ATTENDANCESITE_KAFKA_TOPIC,
            groupId = "bcx_data_sync_attendance_site_to_tlj")
    public void bcxDataSyncAttendanceSiteToTlj(ConsumerRecord<String, String> record, Acknowledgment ack) {
        AttendanceSiteSyncMessage attSite = KafkaMessageUtil.transferKafkaAttSiteRecord2Message(record);
        log.info("kafka监听tlk_attendance_site_base_info表，数据转化为：{}", JSONObject.toJSONString(attSite));
        try {
            if (attSite != null) {
                boolean openAndEffective = organizationOpenService.isOpenAndEffective(attSite.getOrganizationId(), OpenType.TLJ.getCode());
                if (openAndEffective) {
                    Long entid = ebEnterpriseService.getIdByOrgId(attSite.getOrganizationId());
                    if (entid != null) {
                        log.info("组织id：{}，有开通陀螺匠，所以需要同步驻勤点信息", attSite.getOrganizationId());
                        DateTime endDate = DateUtil.offsetDay(attSite.getAfterEndDate(), 1);
                        Date now = new Date();
                        if (attSite.getType().getCode() == DataOperationType.CREATE.getCode()) {
                            log.info("组织id：{}，新增驻勤点信息", attSite.getOrganizationId());
                            if (endDate.after(now)) {
                                log.info("组织id：{}，新增驻勤点信息，驻勤点在有效期内", attSite.getOrganizationId());
                                ebAttendanceGroupService.attendanceGroupCreate(entid, attSite.getAttendanceSiteId(), attSite.getAfterAttSiteName(),
                                        attSite.getAfterFullAddress(), attSite.getAfterLongitude(), attSite.getAfterLatitude(),
                                        attSite.getAfterPerformRange(), attSite.getAfterPrincipal(), attSite.getAttType());
                            }
                        } else if (attSite.getType().getCode() == DataOperationType.UPDATE.getCode()) {
                            log.info("组织id：{}，修改了驻勤点信息", attSite.getOrganizationId());
                            if (endDate.after(now)) {
                                log.info("组织id：{}，修改了驻勤点信息，驻勤点在有效期内", attSite.getOrganizationId());
                                ebAttendanceGroupService.attendanceGroupCreate(entid, attSite.getAttendanceSiteId(), attSite.getAfterAttSiteName(),
                                        attSite.getAfterFullAddress(), attSite.getAfterLongitude(), attSite.getAfterLatitude(),
                                        attSite.getAfterPerformRange(), attSite.getAfterPrincipal(), attSite.getAttType());
                            } else {
                                log.info("组织id：{}，修改了驻勤点信息，驻勤点过期了，删除", attSite.getOrganizationId());
                                ebAttendanceGroupService.attendanceGroupDelete(Collections.singletonList(attSite.getAttendanceSiteId()));
                            }
                        } else {
                            log.info("组织id：{}，删除了驻勤点信息，删除", attSite.getOrganizationId());
                            ebAttendanceGroupService.attendanceGroupDelete(Collections.singletonList(attSite.getAttendanceSiteId()));
                        }
                    }
                } else {
                    log.info("组织id：{}，没开通陀螺匠，所以不需要同步驻勤点信息", attSite.getOrganizationId());
                }
            }
        } catch (Exception e) {
            log.error("kafka监听tlk_attendance_site_base_info表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
