package com.bcxin.sync.configs;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * description：数据同步配置
 * author：linchunpeng
 * date：2024/12/31
 */
@Data
@Component
@ConfigurationProperties(prefix = "sync-config")
public class SyncConfig {

    //是否设置默认密码
    private Boolean isDefaultPassword;
    //jvs主租户id
    private String jvsMainId;
    //相关服务url地址
    private ApiHost apiHost;
    //相关服务url地址
    private OaTemplate oaTemplate;
    //华为云监控配置
    private HuaweiIvm huaweiIvm;
    //回放视频存放地址-本地
    private String videoPlaybackSavePath;
    //回放视频存放地址-obs
    private String videoPlaybackSaveObsPath;
    //obs的cdn域名
    private String obsCdnUrl;

    @Data
    public static class ApiHost {
        //本服务
        private String self;
        //陀螺匠接口域名
        private String tuoluojiang;
        //图片域名（v5一些地址是/uploads开头的）
        private String imageServer;
        //v5
        private String v5;
        //jvs接口域名
        private String jvs;
        //jvs回调地址
        private String jvsOauthCallback;
    }

    @Data
    public static class OaTemplate {
        //以这个企业id的oa模板进行同步
        private Long entid;
    }

    @Data
    public static class HuaweiIvm {
        private String host;
        private String userId;
        private String ak;
        private String sk;
    }
}
