package com.bcxin.sync.configs;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.sync.entity.datasync.OrganizationOpenEntity;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.InMemoryTokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@EnableAuthorizationServer   //开启验证服务器
@Configuration
public class OAuth2Configuration extends AuthorizationServerConfigurerAdapter {

    @Autowired
    private AuthenticationManager manager;
    @Autowired
    private UserDetailsService service;
    @Autowired
    private SyncConfig syncConfig;
    @Autowired
    private OrganizationOpenService organizationOpenService;

    private final BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();

    /**
     * 这个方法是对客户端进行配置，一个验证服务器可以预设很多个客户端，
     * 之后这些指定的客户端就可以按照下面指定的方式进行验证
     * @param clients 客户端配置工具
     */
    @Override
    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
//        List<String> redirectUriList = getRedirectUriList();
        clients
                .inMemory()   //这里我们直接硬编码创建，当然也可以像Security那样自定义或是使用JDBC从数据库读取
                .withClient("jvs")   //客户端名称，随便起就行
                .secret(encoder.encode("jvs-secret"))      //只与客户端分享的secret，随便写，但是注意要加密
                .scopes("all")     //授权范围，这里我们使用全部all
                .resourceIds("security_resource")
                .autoApprove(true) //自动审批
//                .redirectUris(redirectUriList.toArray(new String[0]))
                .redirectUris(syncConfig.getApiHost().getJvs())
                .authorizedGrantTypes("client_credentials", "password", "implicit", "authorization_code", "refresh_token");
    }

    @Override
    public void configure(AuthorizationServerSecurityConfigurer security) {
        security
                .passwordEncoder(encoder)    //编码器设定为BCryptPasswordEncoder
                .allowFormAuthenticationForClients()  //允许客户端使用表单验证，一会我们POST请求中会携带表单信息
                .checkTokenAccess("permitAll()") //允许所有的Token查询请求
                ;
    }

    @Override
    public void configure(AuthorizationServerEndpointsConfigurer endpoints) {
        endpoints.authenticationManager(manager)
                .userDetailsService(service)
                .tokenStore(tokenStore())
                .tokenServices(tokenServices())
        ;
    }

    // 设置token的存储，过期时间，添加附加信息等
    @Bean
    public AuthorizationServerTokenServices tokenServices() {
        DefaultTokenServices services = new DefaultTokenServices();
        services.setReuseRefreshToken(true);
        services.setTokenStore(tokenStore());
        TokenEnhancerChain tokenEnhancerChain = new TokenEnhancerChain();
        tokenEnhancerChain.setTokenEnhancers(Arrays.asList(jwtTokenEnhancer(), accessTokenConverter()));
        services.setTokenEnhancer(tokenEnhancerChain);
        return services;
    }

    @Bean
    public TokenStore tokenStore() {
        return new JwtTokenStore(accessTokenConverter());
//        return new InMemoryTokenStore();
//        return new RedisTokenStore(redisConnectionFactory);
    }

    @Bean
    public JwtAccessTokenConverter accessTokenConverter() {
        JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
        converter.setSigningKey("data_sync");
        return converter;
    }

    @Bean
    public CustomTokenEnhancer jwtTokenEnhancer() {
        return new CustomTokenEnhancer();
    }

    /**
     * description：获取授权域名列表
     * author：linchunpeng
     * date：2025/3/26
     */
//    private List<String> getRedirectUriList() {
//        List<OrganizationOpenEntity> jvsList = organizationOpenService.getJvsList();
//        List<String> redirectUriList = new ArrayList<>();
//        redirectUriList.add("https://".concat(syncConfig.getApiHost().getJvsMain()));
//        if (CollectionUtil.isNotEmpty(jvsList)) {
//            for (OrganizationOpenEntity open : jvsList) {
//                redirectUriList.add("https://".concat(open.getOrganizationId()).concat(".").concat(syncConfig.getApiHost().getJvsMain()));
//            }
//        }
//        return redirectUriList;
//    }

}