package com.bcxin.sync.configs;

import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.zaxxer.hikari.HikariDataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

@Configuration
public class DataSourceConfig {

    @Primary
    @Bean(name = "datasyncDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.datasync")
    public DataSource datasyncDataSource() {
        return new HikariDataSource();
    }

    @Bean(name = "tenantDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.tenant")
    public DataSource tenantDataSource() {
        return new HikariDataSource();
    }

    @Bean(name = "tuoluojiangDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.tuoluojiang")
    public DataSource tuoluojiangDataSource() {
        return new HikariDataSource();
    }

    @Bean(name = "jvsDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.jvs")
    public DataSource jvsDataSource() {
        return new HikariDataSource();
    }

    @Bean(name = "yehuoDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.yehuo")
    public DataSource yehuoDataSource() {
        return new HikariDataSource();
    }

    @Primary
    @Bean(name = "datasyncTransactionManager")
    public DataSourceTransactionManager datasyncTransactionManager(@Qualifier("datasyncDataSource") DataSource datasyncDataSource) {
        return new DataSourceTransactionManager(datasyncDataSource);
    }

    @Bean(name = "tenantTransactionManager")
    public DataSourceTransactionManager tenantTransactionManager(@Qualifier("tenantDataSource") DataSource tenantDataSource) {
        return new DataSourceTransactionManager(tenantDataSource);
    }

    @Bean(name = "tuoluojiangTransactionManager")
    public DataSourceTransactionManager tuoluojiangTransactionManager(@Qualifier("tuoluojiangDataSource") DataSource tuoluojiangDataSource) {
        return new DataSourceTransactionManager(tuoluojiangDataSource);
    }

    @Bean(name = "jvsTransactionManager")
    public DataSourceTransactionManager jvsTransactionManager(@Qualifier("jvsDataSource") DataSource jvsDataSource) {
        return new DataSourceTransactionManager(jvsDataSource);
    }

    @Bean(name = "yehuoTransactionManager")
    public DataSourceTransactionManager yehuoTransactionManager(@Qualifier("yehuoDataSource") DataSource yehuoDataSource) {
        return new DataSourceTransactionManager(yehuoDataSource);
    }

    @Primary
    @Bean(name = "datasyncSqlSessionFactory")
    public SqlSessionFactory datasyncSqlSessionFactory(@Qualifier("datasyncDataSource") DataSource datasyncDataSource) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(datasyncDataSource);
        sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mybatis/datasync/*.xml"));
        return sessionFactoryBean.getObject();
    }

    @Bean(name = "tenantSqlSessionFactory")
    public SqlSessionFactory tenantSqlSessionFactory(@Qualifier("tenantDataSource") DataSource tenantDataSource) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(tenantDataSource);
        sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mybatis/tenant/*.xml"));
        return sessionFactoryBean.getObject();
    }

    @Bean(name = "tuoluojiangSqlSessionFactory")
    public SqlSessionFactory tuoluojiangSqlSessionFactory(@Qualifier("tuoluojiangDataSource") DataSource tuoluojiangDataSource) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(tuoluojiangDataSource);
        sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mybatis/tuoluojiang/*.xml"));
        return sessionFactoryBean.getObject();
    }

    @Bean(name = "jvsSqlSessionFactory")
    public SqlSessionFactory jvsSqlSessionFactory(@Qualifier("jvsDataSource") DataSource jvsDataSource) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(jvsDataSource);
        sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mybatis/jvs/*.xml"));
        return sessionFactoryBean.getObject();
    }

    @Bean(name = "yehuoSqlSessionFactory")
    public SqlSessionFactory yehuoSqlSessionFactory(@Qualifier("yehuoDataSource") DataSource yehuoDataSource) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(yehuoDataSource);
        sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mybatis/yehuo/*.xml"));
        return sessionFactoryBean.getObject();
    }
}
