package com.bcxin.sync.common.utils;

import com.alibaba.fastjson.JSON;
import com.bcxin.sync.common.emus.DataOperationType;
import com.bcxin.sync.common.emus.EmployedStatus;
import com.bcxin.sync.common.emus.OccupationType;
import com.bcxin.sync.dtos.kafka.message.*;
import com.bcxin.sync.dtos.kafka.record.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;

/**
 * 提取kafkare的record中的信息
 */
public class KafkaMessageUtil {
    /**
     * 部门信息转换
     *
     * @param consumerRecord
     * @return
     */
    public static DepartmentSyncMessage transferKafkaDeptRecord2Message(ConsumerRecord<String, String> consumerRecord) {

        DepartmentSyncMessage message = new DepartmentSyncMessage();
        DepartmentKafkaRecord record = JSON.parseObject(consumerRecord.value(), DepartmentKafkaRecord.class);
        DepartmentKafkaRecord.DepartmentRecord before = record.getBefore();
        DepartmentKafkaRecord.DepartmentRecord after = record.getAfter();
        if (before == null) {
            //新增
            message.setOrganizationId(after.getOrganization_id());
            message.setDepartmentId(after.getId());
            message.setAfterDepartmentName(after.getName());
            message.setAfterParentId(after.getParent_id());
            message.setType(DataOperationType.CREATE);
        } else {
            //理论上after不会为null，除非手动删除数据库数据
            if (after == null || after.getIs_deleted() == 1) {
                //删除
                message.setOrganizationId(before.getOrganization_id());
                message.setDepartmentId(before.getId());
                message.setType(DataOperationType.DELETE);
            } else {
                //修改
                message.setOrganizationId(after.getOrganization_id());
                message.setDepartmentId(after.getId());
                message.setBeforeDepartmentName(before.getName());
                message.setBeforeParentId(before.getParent_id());
                message.setAfterDepartmentName(after.getName());
                message.setAfterParentId(after.getParent_id());
                message.setType(DataOperationType.UPDATE);
            }
        }
        return message;
    }

    /**
     * 分组信息转换
     */
    public static ExternalGroupSyncMessage transferKafkaGroupRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        ExternalGroupSyncMessage message = new ExternalGroupSyncMessage();
        ExternalGroupKafkaRecord record = JSON.parseObject(consumerRecord.value(), ExternalGroupKafkaRecord.class);
        ExternalGroupKafkaRecord.ExternalGroupRecord before = record.getBefore();
        ExternalGroupKafkaRecord.ExternalGroupRecord after = record.getAfter();
        if (before == null) {
            //新增
            message.setReferenceType(after.getReference_type());
            message.setReferenceNumber(after.getReference_number());
            message.setGroupId(after.getId());
            message.setAfterGroupName(after.getName());
            message.setAfterParentId(after.getParent_id());
            message.setType(DataOperationType.CREATE);
        } else if (after == null) {
            //删除
            message.setReferenceType(before.getReference_type());
            message.setReferenceNumber(before.getReference_number());
            message.setGroupId(before.getId());
            message.setBeforeGroupName(before.getName());
            message.setBeforeParentId(before.getParent_id());
            message.setType(DataOperationType.DELETE);
        } else {
            //修改
            message.setReferenceType(after.getReference_type());
            message.setReferenceNumber(after.getReference_number());
            message.setGroupId(after.getId());
            message.setBeforeGroupName(before.getName());
            message.setAfterGroupName(after.getName());
            message.setBeforeParentId(before.getParent_id());
            message.setAfterParentId(after.getParent_id());
            message.setType(DataOperationType.UPDATE);
        }
        return message;
    }

    /**
     * 驻勤点信息转换
     * @param consumerRecord
     * @return
     */
    public static AttendanceSiteSyncMessage transferKafkaAttSiteRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        AttendanceSiteSyncMessage message = new AttendanceSiteSyncMessage();
        AttendanceSiteKafkaRecord record = JSON.parseObject(consumerRecord.value(), AttendanceSiteKafkaRecord.class);
        AttendanceSiteKafkaRecord.AttendanceSiteRecord before = record.getBefore();
        AttendanceSiteKafkaRecord.AttendanceSiteRecord after = record.getAfter();
        if (before == null) {
            //新增
            message.setAttendanceSiteId(after.getId());
            message.setOrganizationId(after.getDomainid());
            message.setAttType(after.getItem_att_type());

            message.setAfterAttSiteName(after.getItem_attendanceSiteName());
            message.setAfterFullAddress(after.getItem_attendanceSiteFullAddress());
            message.setAfterLongitude(after.getItem_attendanceSiteLongitude());
            message.setAfterLatitude(after.getItem_attendanceSiteLatitude());
            message.setAfterPerformRange(after.getItem_performRange());
            message.setAfterStartDate(after.getItem_attendanceStartDate());
            message.setAfterEndDate(after.getItem_attendanceEndDate());
            message.setAfterPrincipal(after.getItem_principal());
            message.setType(DataOperationType.CREATE);
        } else if(after != null){
            //理论上after不会为null，除非手动删除数据库数据.驻勤点没有删除功能
            message.setAttendanceSiteId(after.getId());
            message.setOrganizationId(after.getDomainid());
            message.setAttType(after.getItem_att_type());

            message.setBeforeAttSiteName(before.getItem_attendanceSiteName());
            message.setBeforeFullAddress(before.getItem_attendanceSiteFullAddress());
            message.setBeforeLongitude(before.getItem_attendanceSiteLongitude());
            message.setBeforeLatitude(before.getItem_attendanceSiteLatitude());
            message.setBeforePerformRange(before.getItem_performRange());
            message.setBeforeStartDate(before.getItem_attendanceStartDate());
            message.setBeforeEndDate(before.getItem_attendanceEndDate());
            message.setBeforePrincipal(before.getItem_principal());

            message.setAfterAttSiteName(after.getItem_attendanceSiteName());
            message.setAfterFullAddress(after.getItem_attendanceSiteFullAddress());
            message.setAfterLongitude(after.getItem_attendanceSiteLongitude());
            message.setAfterLatitude(after.getItem_attendanceSiteLatitude());
            message.setAfterPerformRange(after.getItem_performRange());
            message.setAfterStartDate(after.getItem_attendanceStartDate());
            message.setAfterEndDate(after.getItem_attendanceEndDate());
            message.setAfterPrincipal(after.getItem_principal());

            message.setType(DataOperationType.UPDATE);
        }else{
            //驻勤点暂时没有业务逻辑删除的场景
            message.setAttendanceSiteId(before.getId());
            message.setOrganizationId(before.getDomainid());
            message.setAttType(before.getItem_att_type());
            message.setType(DataOperationType.DELETE);
        }
        return message;
    }

    public static AttendanceSitePersonSyncMessage transferKafkaAttSitePersonRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        AttendanceSitePersonSyncMessage message = new AttendanceSitePersonSyncMessage();
        AttendanceSitePersonKafkaRecord record = JSON.parseObject(consumerRecord.value(), AttendanceSitePersonKafkaRecord.class);
        AttendanceSitePersonKafkaRecord.AttendanceSitePersonRecord before = record.getBefore();
        AttendanceSitePersonKafkaRecord.AttendanceSitePersonRecord after = record.getAfter();
        if (after != null){
            message.setOrganizationId(after.getDomainId());
            message.setAttSiteId(after.getITEM_attendanceSiteId());
            message.setEmployeeId(after.getITEM_securityId());
            message.setReportingTime(after.getITEM_REPORTING_TIME());
            message.setPushAttendance(after.getItem_push_attendance());
            message.setType(DataOperationType.CREATE);
        } else {
            message.setOrganizationId(before.getDomainId());
            message.setAttSiteId(before.getITEM_attendanceSiteId());
            message.setEmployeeId(before.getITEM_securityId());
            message.setType(DataOperationType.DELETE);
        }
        return message;
    }

    public static EbEnterpriseMessageNoticeSyncMessage transferKafkaEbEnterpriseMessageNoticeRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        EbEnterpriseMessageNoticeSyncMessage message = new EbEnterpriseMessageNoticeSyncMessage();
        EbEnterpriseMessageNoticeKafkaRecord record = JSON.parseObject(consumerRecord.value(), EbEnterpriseMessageNoticeKafkaRecord.class);
        EbEnterpriseMessageNoticeKafkaRecord.EbEnterpriseMessageNoticeRecord before = record.getBefore();
        EbEnterpriseMessageNoticeKafkaRecord.EbEnterpriseMessageNoticeRecord after = record.getAfter();
        if(before == null){
            message.setEntid(after.getEntid());
            message.setAdminId(after.getTo_uid());
            message.setTitle(after.getTitle());
            message.setMessage(after.getMessage());
            message.setMessageType(after.getType());
            message.setCateId(after.getCate_id());
            message.setCateName(after.getCate_name());
            message.setCreatedAt(after.getCreated_at());
            message.setType(DataOperationType.CREATE);
        } else{
            message = null;
        }
        return message;
    }

    public static EmployeeSyncMessage transferKafkaEmployeeRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        EmployeeSyncMessage message = new EmployeeSyncMessage();
        EmployeeKafkaRecord record = JSON.parseObject(consumerRecord.value(), EmployeeKafkaRecord.class);
        EmployeeKafkaRecord.EmployeeRecord before = record.getBefore();
        EmployeeKafkaRecord.EmployeeRecord after = record.getAfter();
        if(before == null){
            //新入职
            message.setOrganizationId(after.getOrganization_id());
            message.setEmployeeId(after.getId());
            message.setUserId(after.getTenant_user_id());
            message.setHireDate(after.getHired_date());
            message.setAfterDeptId(after.getDepartment_id());
            message.setAfterStatus(EmployedStatus.getByCode(after.getStatus()));
            message.setOccupationType(OccupationType.getByCode(after.getOccupation_type()));
            message.setAfterIsDomainAdmin(after.getIs_domain_admin());
            message.setOpType(DataOperationType.CREATE);
        }else if(after != null){
            message.setOrganizationId(after.getOrganization_id());
            message.setEmployeeId(after.getId());
            message.setUserId(after.getTenant_user_id());
            message.setHireDate(after.getHired_date());
            message.setLeaveDate(after.getLeave_time());
            message.setBeforeDeptId(before.getDepartment_id());
            message.setAfterDeptId(after.getDepartment_id());
            message.setBeforeStatus(EmployedStatus.getByCode(before.getStatus()));
            message.setAfterStatus(EmployedStatus.getByCode(after.getStatus()));
            message.setOccupationType(OccupationType.getByCode(after.getOccupation_type()));
            message.setBeforeIsDomainAdmin(before.getIs_domain_admin());
            message.setAfterIsDomainAdmin(after.getIs_domain_admin());
            message.setOpType(DataOperationType.UPDATE);
        }else{
            //删除保安员场景理论上不存在
            message = null;
        }
        if (message != null
                && message.getBeforeStatus() != null && message.getBeforeStatus().getCode() == 1
                && message.getAfterStatus() != null && message.getAfterStatus().getCode() == 1) {
            //监听到：变化前是离职  变化后是离职，这种数据，可以不用管了
            return null;
        }
        return message;
    }

    public static ExternalMemberSyncMessage transferKafkaMemberRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        ExternalMemberSyncMessage message = new ExternalMemberSyncMessage();
        ExternalMemberKafkaRecord record = JSON.parseObject(consumerRecord.value(), ExternalMemberKafkaRecord.class);
        ExternalMemberKafkaRecord.ExternalMemberRecord before = record.getBefore();
        ExternalMemberKafkaRecord.ExternalMemberRecord after = record.getAfter();
        if(before == null && after.getApproved_information_status() == 1){
            //新加入 && 审批通过
            message.setReferenceType(after.getReference_type());
            message.setReferenceNumber(after.getReference_number());
            message.setMemberId(after.getId());
            message.setUserId(after.getTenant_user_id());
            message.setJoinTime(after.getJoin_time());
            message.setDeletedTime(after.getDeleted_time());
            message.setAfterGroupIdsJson(after.getGroup_ids_json());
            message.setAfterApprovedInformationStatus(after.getApproved_information_status());
            message.setAfterIsDomainAdmin(after.getMember_type()==0?1:0);
            message.setOpType(DataOperationType.CREATE);
        } else if(before != null && after != null && after.getApproved_information_status() != 0) {
            //变更 && 变更后的状态不是待审批
            if (before.getApproved_information_status() == 0 && after.getApproved_information_status() == 2) {
                //待审批 改为 审批不通过，不需要同步数据
                return null;
            }
            if (before.getApproved_information_status() == 0 && after.getApproved_information_status() == 3) {
                //待审批 改为 删除，不需要同步数据
                return null;
            }
            if (before.getApproved_information_status() == 2 && after.getApproved_information_status() == 3) {
                //审批不通过 改为 删除，不需要同步数据
                return null;
            }
            if (before.getApproved_information_status() == 3 && after.getApproved_information_status() == 2) {
                //删除 改为 审批不通过，不需要同步数据
                return null;
            }
            message.setReferenceType(after.getReference_type());
            message.setReferenceNumber(after.getReference_number());
            message.setMemberId(after.getId());
            message.setUserId(after.getTenant_user_id());
            message.setJoinTime(after.getJoin_time());
            message.setDeletedTime(after.getDeleted_time());
            message.setBeforeGroupIdsJson(before.getGroup_ids_json());
            message.setAfterGroupIdsJson(after.getGroup_ids_json());
            message.setBeforeApprovedInformationStatus(before.getApproved_information_status());
            message.setAfterApprovedInformationStatus(after.getApproved_information_status());
            message.setBeforeIsDomainAdmin(before.getMember_type()==0?1:0);
            message.setAfterIsDomainAdmin(after.getMember_type()==0?1:0);
            message.setOpType(DataOperationType.UPDATE);
        }else{
            //删除保安员场景理论上不存在
            message = null;
        }
        return message;
    }

    public static TenantDepartmentEmployeeRelationsSyncMessage transferKafkaTenantDepartmentEmployeeRelationsSyncMessageRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        TenantDepartmentEmployeeRelationsSyncMessage message = new TenantDepartmentEmployeeRelationsSyncMessage();
        TenantDepartmentEmployeeRelationsKafkaRecord record = JSON.parseObject(consumerRecord.value(), TenantDepartmentEmployeeRelationsKafkaRecord.class);
        TenantDepartmentEmployeeRelationsKafkaRecord.TenantDepartmentEmployeeRelationsRecord before = record.getBefore();
        TenantDepartmentEmployeeRelationsKafkaRecord.TenantDepartmentEmployeeRelationsRecord after = record.getAfter();
        if(before == null){
            //新入职
            message.setId(after.getId());
            message.setEmployeeId(after.getEmployee_id());
            message.setAfterDeptId(after.getDepartment_id());
            message.setAfterLeaderType(after.getLeader_type());
            message.setOpType(DataOperationType.CREATE);
        } else if(after != null){
            message.setId(after.getId());
            message.setEmployeeId(after.getEmployee_id());
            message.setBeforeDeptId(before.getDepartment_id());
            message.setBeforeLeaderType(before.getLeader_type());
            message.setAfterDeptId(after.getDepartment_id());
            message.setAfterLeaderType(after.getLeader_type());
            message.setOpType(DataOperationType.UPDATE);
        }else{
            message.setId(before.getId());
            message.setEmployeeId(before.getEmployee_id());
            message.setBeforeDeptId(before.getDepartment_id());
            message.setBeforeLeaderType(before.getLeader_type());
            message.setOpType(DataOperationType.DELETE);
        }
        return message;
    }

    public static TenantOrganizationsSyncMessage transferKafkaOrganizationsRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        TenantOrganizationsSyncMessage message = new TenantOrganizationsSyncMessage();
        TenantOrganizationsKafkaRecord record = JSON.parseObject(consumerRecord.value(), TenantOrganizationsKafkaRecord.class);
        TenantOrganizationsKafkaRecord.TenantOrganizationsRecord before = record.getBefore();
        TenantOrganizationsKafkaRecord.TenantOrganizationsRecord after = record.getAfter();
        if(before != null && after != null){
            message.setOrganizationId(after.getId());
            message.setBeforeName(before.getName());
            message.setAfterName(after.getName());
            message.setBeforeLevel(before.getLevel());
            message.setAfterLevel(after.getLevel());
        }else{
            message = null;
        }
        return message;
    }

    public static TlkEventTeamSyncMessage transferKafkaTlkEventTeamRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        TlkEventTeamSyncMessage message = new TlkEventTeamSyncMessage();
        TlkEventTeamKafkaRecord record = JSON.parseObject(consumerRecord.value(), TlkEventTeamKafkaRecord.class);
        TlkEventTeamKafkaRecord.TlkEventTeamRecord before = record.getBefore();
        TlkEventTeamKafkaRecord.TlkEventTeamRecord after = record.getAfter();
        if(after != null){
            message.setTeamId(after.getItem_team_id());
            message.setTeamName(after.getItem_team_name());
            message.setProjectId(after.getItem_project_id());
        }else{
            message = null;
        }
        return message;
    }

    public static TlkEventProjectSyncMessage transferKafkaTlkEventProjectRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        TlkEventProjectSyncMessage message = new TlkEventProjectSyncMessage();
        TlkEventProjectKafkaRecord record = JSON.parseObject(consumerRecord.value(), TlkEventProjectKafkaRecord.class);
        TlkEventProjectKafkaRecord.TlkEventProjectRecord before = record.getBefore();
        TlkEventProjectKafkaRecord.TlkEventProjectRecord after = record.getAfter();
        if(after != null){
            message.setId(after.getId());
            message.setName(after.getItem_project_name());
            message.setDomainId(after.getItem_domain_id());
            message.setDomainName(after.getItem_domain_name());
            message.setEndTime(after.getItem_project_end_time());
        }else{
            message = null;
        }
        return message;
    }


    public static TlkEventProjectSyncMessage transferKafkaTlkEventProjectRecord2Message2(ConsumerRecord<String, String> consumerRecord) {
        TlkEventProjectSyncMessage message = new TlkEventProjectSyncMessage();
        TlkEventProjectKafkaRecord record = JSON.parseObject(consumerRecord.value(), TlkEventProjectKafkaRecord.class);
        TlkEventProjectKafkaRecord.TlkEventProjectRecord before = record.getBefore();
        TlkEventProjectKafkaRecord.TlkEventProjectRecord after = record.getAfter();
        if(before == null){
            //新增
            message.setId(after.getId());
            message.setName(after.getItem_project_name());
            message.setDomainId(after.getItem_domain_id());
            message.setDomainName(after.getItem_domain_name());
            message.setEndTime(after.getItem_project_end_time());
            message.setLink3d(after.getItem_link_3d());
            message.setAssesmentReport(after.getItem_assesment_report());
            message.setAfterOfficePoliceIdIndex(after.getItem_office_police_id_index());
            message.setOpType(DataOperationType.CREATE);
        }else if(after != null){
            //修改
            String beforeLink3d = StringUtils.isNotBlank(before.getItem_link_3d()) ? before.getItem_link_3d() : "";
            String beforeAssesmentReport = StringUtils.isNotBlank(before.getItem_assesment_report()) ? before.getItem_assesment_report() : "";
            String beforeOfficePoliceIDIndex = StringUtils.isNotBlank(before.getItem_office_police_id_index()) ? before.getItem_office_police_id_index() : "";
            String afterLink3d = StringUtils.isNotBlank(after.getItem_link_3d()) ? after.getItem_link_3d() : "";
            String afterAssesmentReport = StringUtils.isNotBlank(after.getItem_assesment_report()) ? after.getItem_assesment_report() : "";
            String afterOfficePoliceIDIndex = StringUtils.isNotBlank(after.getItem_office_police_id_index()) ? after.getItem_office_police_id_index() : "";
            if (!beforeLink3d.equals(afterLink3d)
                    || !beforeAssesmentReport.equals(afterAssesmentReport)
                    || !beforeOfficePoliceIDIndex.equals(afterOfficePoliceIDIndex)) {
                //赛演3d 或 风评报告 或 监管机构，有发生变更，才需要修改
                message.setId(after.getId());
                message.setName(after.getItem_project_name());
                message.setDomainId(after.getItem_domain_id());
                message.setDomainName(after.getItem_domain_name());
                message.setEndTime(after.getItem_project_end_time());
                message.setLink3d(after.getItem_link_3d());
                message.setAssesmentReport(after.getItem_assesment_report());
                message.setBeforeOfficePoliceIdIndex(before.getItem_office_police_id_index());
                message.setAfterOfficePoliceIdIndex(after.getItem_office_police_id_index());
                message.setOpType(DataOperationType.UPDATE);
            } else {
                message = null;
            }
        }else{
            //删除
            message.setId(before.getId());
            message.setName(before.getItem_project_name());
            message.setDomainId(before.getItem_domain_id());
            message.setDomainName(before.getItem_domain_name());
            message.setEndTime(before.getItem_project_end_time());
            message.setOpType(DataOperationType.DELETE);
        }
        return message;
    }

    public static TenantUserSyncMessage transferKafkaUserRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        TenantUserSyncMessage message = new TenantUserSyncMessage();
        TenantUsersKafkaRecord record = JSON.parseObject(consumerRecord.value(), TenantUsersKafkaRecord.class);
        TenantUsersKafkaRecord.TenantUsersRecord before = record.getBefore();
        TenantUsersKafkaRecord.TenantUsersRecord after = record.getAfter();
        if(before == null && after != null){
            message.setUserId(after.getId());
            message.setAfterName(after.getName());
            message.setAfterTelephone(after.getTelephone());
            message.setOpType(DataOperationType.CREATE);
        } else if(before != null && after != null){
            message.setUserId(after.getId());
            message.setBeforeName(before.getName());
            message.setAfterName(after.getName());
            message.setBeforeTelephone(before.getTelephone());
            message.setAfterTelephone(after.getTelephone());
            message.setOpType(DataOperationType.UPDATE);
        }else{
            message = null;
        }
        return message;
    }

    public static EmployeeAttendanceSyncMessage transferKafkaEmployeeAttendanceRecord2Message(ConsumerRecord<String, String> consumerRecord) {
        EmployeeAttendanceSyncMessage message = new EmployeeAttendanceSyncMessage();
        EmployeeAttendanceRecordKafkaRecord record = JSON.parseObject(consumerRecord.value(), EmployeeAttendanceRecordKafkaRecord.class);
        EmployeeAttendanceRecordKafkaRecord.EmployeeAttendanceRecord before = record.getBefore();
        EmployeeAttendanceRecordKafkaRecord.EmployeeAttendanceRecord after = record.getAfter();
        if(before == null){
            message.setOrgId(after.getOrganization_id());
            message.setEmployeeId(after.getTenant_employee_id());
            message.setAddress(after.getAddress());
            message.setSignTime(after.getCreated_time());
        }else{
            message = null;
        }
        return message;
    }


    /**
     * 权限操作项用户关联表信息转换
     * @param consumerRecord
     * @return
     */
    public static RbacPermitOptionUserSyncMessage transferKafkaRbacPermitOptionUser2Message(ConsumerRecord<String, String> consumerRecord) {
        RbacPermitOptionUserSyncMessage message = new RbacPermitOptionUserSyncMessage();
        RbacPermitOptionUserKafkaRecord record = JSON.parseObject(consumerRecord.value(), RbacPermitOptionUserKafkaRecord.class);
        RbacPermitOptionUserKafkaRecord.RbacPermitOptionUserRecord before = record.getBefore();
        RbacPermitOptionUserKafkaRecord.RbacPermitOptionUserRecord after = record.getAfter();
        if (before == null) {
            //新增
            message.setOrganizationId(after.getOrganization_id());
            message.setTenantEmployeeId(after.getTenant_employee_id());
            message.setPermitOptionId(after.getPermit_option_id());
            message.setOptionCode(after.getOption_code());
//            message.setType(DataOperationType.CREATE);
        } else if (after == null) {
            //删除
            message.setOrganizationId(before.getOrganization_id());
            message.setTenantEmployeeId(before.getTenant_employee_id());
            message.setPermitOptionId(before.getPermit_option_id());
            message.setOptionCode(before.getOption_code());
//            message.setType(DataOperationType.DELETE);
        } else {
            message.setOrganizationId(after.getOrganization_id());
            message.setTenantEmployeeId(after.getTenant_employee_id());
            message.setPermitOptionId(after.getPermit_option_id());
            message.setOptionCode(after.getOption_code());
//            message.setType(DataOperationType.UPDATE);
        }
        return message;
    }


    /**
     * 权限操作项角色关联表信息转换
     * @param consumerRecord
     * @return
     */
    public static RbacPermitOptionRoleSyncMessage transferKafkaRbacPermitOptionRole2Message(ConsumerRecord<String, String> consumerRecord) {
        RbacPermitOptionRoleSyncMessage message = new RbacPermitOptionRoleSyncMessage();
        RbacPermitOptionRoleKafkaRecord record = JSON.parseObject(consumerRecord.value(), RbacPermitOptionRoleKafkaRecord.class);
        RbacPermitOptionRoleKafkaRecord.RbacPermitOptionRoleRecord before = record.getBefore();
        RbacPermitOptionRoleKafkaRecord.RbacPermitOptionRoleRecord after = record.getAfter();
        if (before == null) {
            //新增
            message.setOrganizationId(after.getOrganization_id());
            message.setRbacRoleId(after.getRbac_role_id());
            message.setPermitOptionId(after.getPermit_option_id());
            message.setOptionCode(after.getOption_code());
//            message.setType(DataOperationType.CREATE);
        } else if (after == null) {
            //删除
            message.setOrganizationId(before.getOrganization_id());
            message.setRbacRoleId(before.getRbac_role_id());
            message.setPermitOptionId(before.getPermit_option_id());
            message.setOptionCode(before.getOption_code());
//            message.setType(DataOperationType.DELETE);
        } else {
            message.setOrganizationId(after.getOrganization_id());
            message.setRbacRoleId(after.getRbac_role_id());
            message.setPermitOptionId(after.getPermit_option_id());
            message.setOptionCode(after.getOption_code());
//            message.setType(DataOperationType.UPDATE);
        }
        return message;
    }

    /**
     * 权限操作项角色关联表信息转换
     * @param consumerRecord
     * @return
     */
    public static RbacCustomRoleUserSyncMessage transferKafkaRbacCustomRoleUser2Message(ConsumerRecord<String, String> consumerRecord) {
        RbacCustomRoleUserSyncMessage message = new RbacCustomRoleUserSyncMessage();
        RbacCustomRoleUserKafkaRecord record = JSON.parseObject(consumerRecord.value(), RbacCustomRoleUserKafkaRecord.class);
        RbacCustomRoleUserKafkaRecord.RbacCustomRoleUserRecord before = record.getBefore();
        RbacCustomRoleUserKafkaRecord.RbacCustomRoleUserRecord after = record.getAfter();
        if (before == null) {
            //新增
            message.setOrganizationId(after.getOrganization_id());
            message.setRbacRoleId(after.getRbac_role_id());
            message.setTenantEmployeeId(after.getTenant_employee_id());
            message.setType(DataOperationType.CREATE);
        } else if (after == null) {
            //删除
            message.setOrganizationId(before.getOrganization_id());
            message.setRbacRoleId(before.getRbac_role_id());
            message.setRbacRoleId(before.getRbac_role_id());
            message.setTenantEmployeeId(before.getTenant_employee_id());
            message.setType(DataOperationType.DELETE);
        } else {
            message.setOrganizationId(after.getOrganization_id());
            message.setRbacRoleId(after.getRbac_role_id());
            message.setRbacRoleId(after.getRbac_role_id());
            message.setTenantEmployeeId(after.getTenant_employee_id());
            message.setType(DataOperationType.UPDATE);
        }
        return message;
    }
}
