/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.sys;

import cn.hutool.core.map.MapUtil;
import com.bcxin.risk.report.material.dao.MaterialFormOptionDao;
import com.bcxin.risk.report.material.domain.MaterialFormOption;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysMaterialOptionUtil {
    @Resource
    private MaterialFormOptionDao materialFormOptionDao;
    private Map<String, Collection<MaterialFormOption>> CACHE_KEY_MATERIAL_OPTION = Maps.newHashMap();

    public String getOptionLabel(String value, String type, String defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)value)) {
            Collection<MaterialFormOption> list = this.optionMap().get(type.toUpperCase());
            for (MaterialFormOption option : list) {
                if (!value.equals(option.getValue())) continue;
                return option.getName();
            }
        }
        return defaultValue;
    }

    public Collection<MaterialFormOption> getOptionList(String type) {
        return this.optionMap().get(type.toUpperCase());
    }

    public Map<String, Collection<MaterialFormOption>> optionMap() {
        if (MapUtil.isNotEmpty(this.CACHE_KEY_MATERIAL_OPTION)) {
            return this.CACHE_KEY_MATERIAL_OPTION;
        }
        List dictList = this.materialFormOptionDao.selectOptionList();
        ArrayListMultimap map = ArrayListMultimap.create();
        for (MaterialFormOption option : dictList) {
            map.put((Object)option.getType().toUpperCase(), (Object)option);
        }
        this.CACHE_KEY_MATERIAL_OPTION = map.asMap();
        return this.CACHE_KEY_MATERIAL_OPTION;
    }
}

