/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ObjectUtil {
    public static Map<String, String> getFieldValueMap(Object bean) {
        Field[] fields;
        Class<?> cls = bean.getClass();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        Method[] methods = cls.getDeclaredMethods();
        for (Field field : fields = cls.getDeclaredFields()) {
            try {
                String fieldType = field.getType().getSimpleName();
                String fieldGetName = ObjectUtil.parGetName(field.getName());
                if (!ObjectUtil.checkGetMet(methods, fieldGetName)) continue;
                Method fieldGetMet = cls.getMethod(fieldGetName, new Class[0]);
                Object fieldVal = fieldGetMet.invoke(bean, new Object[0]);
                String result = null;
                if ("String".equals(fieldType) && null != fieldVal) {
                    result = String.valueOf(fieldVal);
                }
                valueMap.put(field.getName(), result);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return valueMap;
    }

    public static void setFieldValue(Object bean, Map<String, String> valMap) {
        Field[] fields;
        Class<?> cls = bean.getClass();
        Method[] methods = cls.getDeclaredMethods();
        for (Field field : fields = cls.getDeclaredFields()) {
            try {
                String fieldSetName = ObjectUtil.parSetName(field.getName());
                if (!ObjectUtil.checkSetMet(methods, fieldSetName)) continue;
                Method fieldSetMet = cls.getMethod(fieldSetName, field.getType());
                String value = valMap.get(field.getName());
                if (null == value || "".equals(value)) continue;
                String fieldType = field.getType().getSimpleName();
                fieldSetMet.invoke(bean, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static boolean checkSetMet(Method[] methods, String fieldSetMet) {
        for (Method met : methods) {
            if (!fieldSetMet.equals(met.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkGetMet(Method[] methods, String fieldGetMet) {
        for (Method met : methods) {
            if (!fieldGetMet.equals(met.getName())) continue;
            return true;
        }
        return false;
    }

    private static String parGetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static String parSetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String safeTransfor(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }
}

