<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="/static/weixin/css/public.css">
    <link rel="stylesheet" href="/static/weixin/css/basic.css">
    <link rel="stylesheet" href="/static/weixin/css/SG_area_select.css?v=1.0.6">
    <script src="/static/weixin/js/flexible.js"></script>
    <script src="/static/weixin/js/jquery-1.8.3.min.js"></script>
    <script type="text/javascript" src="/static/weixin/js/g.js"></script>
    <title>收入详情</title>
</head>
<body id="contain">
<div class="contain">
    <div class="bai-head">
        <span>账单详情</span>
        <a href="javascript:history.go(-1);" class="left">
            <img src="/static/weixin/images/head-left.png"/>
        </a>
    </div>
    <div class="lower-level bill-level">
        <h2>账单详情</h2>
        <ul class="basic-information distributor-level">
            <li>
                <span>订单编号</span>
                <p name="orderNo">${orderDetail.orderNo}</p>
            </li>
            <li>
                <span>产品名称</span>
                <p name="productName">${orderDetail.productName}</p>
            </li>
            <li>
                <span>产品分类</span>
                <p name="productTypeName">${orderDetail.productTypeName}</p>
            </li>
            <li>
                <span>项目活动</span>
                <p id="projectName" name="projectName">${orderDetail.projectName}</p>
            </li>
            <li>
                <span>有效日期</span>
                <p id="effect_date" name="effect_date">
                    ${orderDetail.startDate}~${orderDetail.endDate}
                </p>
            </li>
            <li>
                <span>是否分期</span>
                <p id="stages_number" name="stages_number">
                    <c:if test="${orderDetail.stagesNum=='1' }">
                        否
                    </c:if>
                    <c:if test="${orderDetail.stagesNum!='1' }">
                        分${orderDetail.stagesNum}期
                    </c:if>
                </p>
            </li>
            <li>
                <span>支付情况</span>
                <p id="is_pay" name="is_pay">
                    <c:if test="${orderDetailPay.payStatus !=null}">
                        <c:if test="${orderDetailPay.payStatus=='0' }">
                            已支付
                        </c:if>
                        <c:if test="${orderDetailPay.payStatus=='1' }">
                            部分支付
                        </c:if>
                        <c:if test="${orderDetailPay.payStatus=='-1' }">
                            未支付
                        </c:if>
                    </c:if>
                    <c:if test="${orderDetailPay.payStatus ==null}">
                        --
                    </c:if>
                </p>
            </li>
            <li>
                <span>订单费用</span>
                <p id="orderAmount" name="orderAmount">￥${orderDetail.orderAmount}</p>
            </li>
            <c:if test="${p.weixin_login_company_type!=4}">
            <li>
                <span>来源</span>
                <p id="sourceCompanyName" name="sourceCompanyName">${orderDetail.sourceCompanyName}</p>
            </li>
            </c:if>
            <li>
                <span>支付时间</span>
                <p name="orderDate">
                    <c:if test="${orderDetail.payDate == null}">
                        --
                    </c:if>
                    <c:if test="${orderDetail.payDate != null}">
                        ${orderDetail.payDate}
                    </c:if>
                </p>
            </li>
        </ul>
        <h2>结算信息</h2>
        <ul class="basic-information distributor-level">
            <c:if test="${p.weixin_login_distribution_level eq '1' ||  p.weixin_login_company_type eq '4'}">
            <li>
                <span>结算状态</span>
                <p name="currOrderAmount">
                    <c:if test="${orderDetail.monthStatus=='1' }">
                        已结算
                    </c:if>
                    <c:if test="${orderDetail.monthStatus!='1' }">
                        未结算
                    </c:if>
                </p>
            </li>
            </c:if>
            <li>
                <span>订单收入</span>
                <p name="currOrderAmount">￥${orderDetail.currOrderAmount}</p>
            </li>
            <c:if test="${p.weixin_login_distribution_level!='3' }">
                <c:if test="${p.weixin_login_company_type!=4}">
                <li>
                    <span>下级收入</span>
                    <p name="lowerOrderAmount">￥${orderDetail.lowerOrderAmount}</p>
                </li>
                </c:if>
            </c:if>

            <c:if test="${p.weixin_login_company_type!=4}">
            <li>
                <span>净收入</span>
                <p name="currOrderAmount">￥${orderDetail.currAmount}</p>
            </li>
            </c:if>
        </ul>
    </div>
</div>
</body>
</html>