/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cache;

import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.ThreadUtil;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public enum GlobalPruneTimer {
    INSTANCE;

    private AtomicInteger cacheTaskNumber = new AtomicInteger(1);
    private ScheduledExecutorService pruneTimer;

    private GlobalPruneTimer() {
        this.create();
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay) {
        return this.pruneTimer.scheduleAtFixedRate(task, delay, delay, TimeUnit.MILLISECONDS);
    }

    public void create() {
        if (null != this.pruneTimer) {
            this.shutdownNow();
        }
        this.pruneTimer = new ScheduledThreadPoolExecutor(16, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return ThreadUtil.newThread(r, StrUtil.format((CharSequence)"Pure-Timer-{}", GlobalPruneTimer.this.cacheTaskNumber.getAndIncrement()));
            }
        });
    }

    public void shutdown() {
        if (null != this.pruneTimer) {
            this.pruneTimer.shutdown();
        }
    }

    public List<Runnable> shutdownNow() {
        if (null != this.pruneTimer) {
            return this.pruneTimer.shutdownNow();
        }
        return null;
    }
}

