<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="/static/weixin/css/public.css">
    <link rel="stylesheet" href="/static/weixin/css/wechat_add_new.css">
    <link rel="stylesheet" href="/static/weixin/css/basic.css">
    <script src="/static/weixin/js/flexible.js"></script>
    <title>城市选择</title>
    <style>
        .sd_city_selection .select_content ul {
            min-height: 80px !important;
        }
        #wrapper{
            overflow: auto;
            top: 1.1rem;
        }
        /*.administer-head {*/
            /*padding: 0.31333rem 0.32rem;*/
        /*}*/
    </style>
</head>
<body id="contain">
<div class="contain">
    <div class="bai-head">
        <span>城市选择</span>
        <a href="/weixin/billNewPage/billCondition?product_type=${p.product_type}" class="left">
            <img src="/static/weixin/images/head-left.png"/>
        </a>
    </div>
    <div class="administer-head">
        <input id="keyword" type="text" placeholder="请输入关键字搜索">
        <span class="head-remove"></span>
        <a id="searchBtn" class="head-serach">搜索</a>
    </div>
        <div id="wrapper" class="sd_city_selection">
            <div class="select_provice select_content">
                <h2>省份</h2>
                <ul class="provice_content">

                </ul>
            </div>
            <div class="select_city select_content">
                <h2>城市</h2>
                <ul class="city_content">

                </ul>
            </div>
            <div class="select_district select_content">
                <h2>区</h2>
                <ul class="district_content">

                </ul>
            </div>
        </div>

</div>
</body>
<script src="/static/weixin/js/jquery-1.8.3.min.js"></script>
<script src="/static/weixin/common/layer_mobile/layer.js"></script>
<link rel="stylesheet" href="/static/weixin/common/layer_mobile/need/right.css">
<script src="/static/weixin/common/jquery.formHelper.js"></script>
<script type="text/javascript" src="/static/weixin/js/g.js"></script>
<script>
    function initEvent(){
        // 搜索框的变化
        $(".administer-head input").focus(function(){
            $('.administer-head input').css({"transition":"all ease-in .5s","width":"84.85%"});
            $(this).siblings('.head-serach').css({"right":'3.2%'});
            re_length = $(this).val().length;
            if(re_length >=1 ){
                $(".administer-head").find('.head-remove').css({"opacity":'1'});
            }
        }).blur(function(){
            sd_width = Math.ceil($('.administer-head .head-serach').width())+10;
            $('.administer-head input').css({"transition":"all ease-in .5s","width":"100%"});
            $(this).siblings('.head-serach').css({"right":-sd_width+'px'});
            $(".administer-head").find('.head-remove').css({"opacity":'0'});
        });
        $(".administer-head").find('input').on('input propertychange',function(){
            re_length = $(this).val().length;
            if(re_length >=1 ){
                $(".administer-head").find('.head-remove').css({"opacity":'1'});
            }else{
                $(".administer-head").find('.head-remove').css({"opacity":'0'});
            }
        });
        $(".administer-head .head-remove").unbind("click").click(function () {
            $(this).siblings('input').val('').focus();
        });

        //点击省份
        $('.select_content ul.provice_content li span').unbind("click").click(function () {
            $('.select_content ul.provice_content li span').removeClass('on');
            $(this).addClass('on');
            provice_name = $(this).text();
            province_id  = $(this).attr("pid");
//            console.log('选中的省份:',provice_name);
            sessionStorage.setItem("sel_region",JSON.stringify({region_name:provice_name,region_id:province_id}));
            window.location.href="/weixin/billNewPage/billCondition?product_type=${p.product_type}";
        });

        //点击城市
        $('.select_content ul.city_content li span').unbind("click").click(function () {
            $('.select_content ul.city_content li span').removeClass('on');
            $(this).addClass('on');
            city_name = $(this).text();
            city_id  = $(this).attr("pid");
//            console.log('选中的城市:',city_name);
            sessionStorage.setItem("sel_region",JSON.stringify({region_name:city_name,region_id:city_id}));
            window.location.href="/weixin/billNewPage/billCondition?product_type=${p.product_type}";
        });

        //点击区域
        $('.select_content ul.district_content li span').unbind("click").click(function () {
            $('.select_content ul.district_content li span').removeClass('on');
            $(this).addClass('on');
            district_name = $(this).text();
            district_id  = $(this).attr("pid");
//            console.log('选中的城市:',city_name);
            sessionStorage.setItem("sel_region",JSON.stringify({region_name:district_name,region_id:district_id}));
            window.location.href="/weixin/billNewPage/billCondition?product_type=${p.product_type}";
        });

        $("#searchBtn").unbind("click").click(function(){
            refresh();
        });
    }(initEvent())


    /**
     * 刷新页面
     */
    function refresh(){
        g_ajax("/weixin/billNewPage/getAreaInfoWithProvince",{keyword:$("#keyword").val()},function(json){
            console.log(json)
            var provinces="";
            //省份
            for(var i in json.province){
                var row = json.province[i];
                provinces +="<li><span pid='"+row.provinceId+"'>"+row.provinceName+"</span></li>";
            }
            $(".provice_content").html(provinces);
            initEvent();
        });

        g_ajax("/weixin/billNewPage/getAreaInfoWithCity",{keyword:$("#keyword").val()},function(json){
            console.log(json)
            var cities="";
            //城市
            for(var i in json.city){
                var row = json.city[i];
                cities +="<li><span pid='"+row.cityId+"'>"+row.cityName+"</span></li>";
            }
            $(".city_content").html(cities);
            initEvent();
        });

        g_ajax("/weixin/billNewPage/getAreaInfoWithDistrict",{keyword:$("#keyword").val()},function(json){
            console.log(json)
            var districts="";
            //区域
            for(var i in json.district){
                var row = json.district[i];
                districts +="<li><span pid='"+row.districtId+"'>"+row.districtName+"</span></li>";
            }
            $(".district_content").html(districts);
            initEvent();
        });

    }(refresh())



</script>
</html>