<%@ page language="java" import="java.util.*" contentType="text/html; charset=utf-8"%>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="${ctxwxsta}/css/public.css">
    <link rel="stylesheet" href="${ctxwxsta}/css/basic.css">
    <link rel="stylesheet" href="${ctxwxsta}/css/SG_area_select.css?v=1.0.6">
    <script src="${ctxwxsta}/js/flexible.js"></script>
    <script src="/static/weixin/common/layer_mobile/layer.js"></script>
    <link rel="stylesheet" href="/static/weixin/common/layer_mobile/need/right.css">
    <title>修改分销商</title>
</head>
<body id="contain">
<div class="contain">
    <div class="bai-head">
        <span>修改分销商</span>
        <a href="javascript:;" onclick="menuList()" class="left">
            <img src="${ctxwxsta}/images/head-left.png"/>
        </a>
        <a href="${ctxwx}/partner/updPartner/${company.id}" class="trash amend">
            <img src="${ctxwxsta}/images/amend.png">
        </a>
    </div>
    <div class="lower-level">
        <h2>基础信息</h2>
        <ul class="basic-information distributor-level">
            <li>
                <span>名称</span>
                <p>${company.companyName}</p>
            </li>
            <li>
                <span>企业/个人</span>
                <p>
                   <c:if test="${company.terminalType eq  '1'}">
                       企业
                   </c:if>
                    <c:if test="${company.terminalType eq  '2'}">
                        个人
                    </c:if>
                </p>
            </li>
            <li>
                <span>证件类型</span>
                <p>
                <c:if test="${company.terminalType  eq '1'}">
                    <c:if  test="${company.documentType  eq '1'}">营业执照</c:if>
                    <c:if  test="${company.documentType  eq '2'}">统一社会信用代码</c:if>
                    <c:if  test="${company.documentType  eq '3'}">组织机构代码证</c:if>
                </c:if>

                <c:if test="${company.terminalType  eq '2'}">
                    <c:if  test="${company.documentType  eq '0'}">身份证</c:if>
                    <c:if  test="${company.documentType  eq '1'}">台胞证</c:if>
                    <c:if  test="${company.documentType  eq '2'}">护照</c:if>
                    <c:if  test="${company.documentType  eq '3'}">回乡证</c:if>
                    <c:if  test="${company.documentType  eq '5'}">其他</c:if>
                </c:if>

                </p>
            </li>
            <li>
                <span>证件号</span>
                <p>${company.organizationCode}</p>
            </li>
            <li>
                <span>所在城市</span>
                <p id="selectBtn"></p>
                <input type="hidden" name="province" value="${company.province}" id="s-province">
                <input type="hidden" name="city" value="${company.city}" id="s-city">
                <input type="hidden" name="district" value="${company.district}" id="s-area">
            </li>
            <li>
                <span>具体地址</span>
                <p>${company.address}</p>
            </li>
        </ul>
        <h2>联系人</h2>
        <ul class="basic-information distributor-level">
            <li>
                <span>姓名</span>
                <p>${contactsList[0].name}</p>
            </li>
            <li>
                <span>手机</span>
                <p>${contactsList[0].contactsWay}</p>
            </li>
            <li>
                <span>电子邮箱</span>
                <p>${contactsList[0].email}</p>
            </li>
        </ul>
        <h2>分销商配置</h2>
        <ul class="basic-information pei-level">
            <li>
                <span>限制销售区域</span>
                <p  onclick="getQuYu()"></p>
            </li>
            <li>
                <span>可销售产品</span>
                <p onclick="getProduct()"></p>
            </li>
            <li>
                <span>账号管理</span>
                <p onclick="getAccount()"></p>
            </li>
        </ul>
        <div class="pro-steps assigned-steps" style="position: relative;top: 80px;">
            <div class="steps">
                <c:if test="${company.status eq '1'}">
                    <button class="xia" type="button" onclick="changeStatus(0,'${company.id}')">禁用</button>
                </c:if>
                <c:if test="${company.status eq '0'}">
                    <button class="xia" type="button" onclick="changeStatus(1,'${company.id}')">启用</button>
                </c:if>
            </div>
        </div>
    </div>

</div>

<script src="${ctxwxsta}/js/jquery-1.8.3.min.js"></script>
<script src="${ctxwxsta}/js/g.js"></script>
<script>
    var baseUrl = '${pageContext.request.contextPath }';
    function  getQuYu() {
        window.location.href=baseUrl+"/weixin/partner/area/${company.id}";
    }
    function  getProduct() {
        window.location.href=baseUrl+"/weixin/product/distributionList/${company.id}";
    }
    function  getAccount() {
        window.location.href=baseUrl+"/weixin/partner/account/${company.id}";
    }

    function  menuList(){
        window.location.href= "/weixin/partner/list";
    }
    $(document).ready(function(){

        var   city=$("#s-province").val()+$("#s-city").val()+$("#s-area").val()+"";
        // alert(city);
        if(city!=''){
            $("#selectBtn").html(g_getRegion($("#s-province").val()).province+g_getRegion($("#s-city").val()).citytype+g_getRegion($("#s-area").val()).city);
        }
    });
    
    function changeStatus(status,companyId) {
            $.ajax({
                type: 'POST',
                url: "/weixin/partner/savePartnerStatus",
                data:{status:status,companyId:companyId},
                dataType:"json",
                async: false,
                success: function(data){
                    if(data.success){
                        location.href=baseUrl+"/weixin/partner/list";
                    }else{
                        layer.open({content:"操作失败！",btn: '我知道了'});

                    }
                }
            });

    }

</script>
</body>
</html>