package com.bcxin.rest.sys.mail;

import java.util.ArrayList;
import java.util.List;


public class EmailModel {
	private String subject;
	private String emailType; // 默认发送保众网（即为空）
	private List<String> to = new ArrayList<String>();
	private List<String> cc = new ArrayList<String>();
	private List<String> bcc = new ArrayList<String>();
	private String content;
	private List<String> filePath = new ArrayList<String>();

	public EmailModel(){}
	
	public EmailModel(String subject, String content){
		this.subject = subject; 
		this.content = content;
	}
	
	public EmailModel(EmailMsgType type, String productName, String policyNum, String date) {
		switch (type) {
		case INSURE_POLICY:
			this.subject = "保单承保通知";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">您投保的"+productName+"已经承保成功，保单号："+policyNum+"，保单生效日期："+date+"。</p>"
					+ "<p style=\"text-indent:2em;\">如有疑问，请致电400-662-9696咨询。</p>";
			break;
		case INSURE_POLICY_FAILD:
			this.subject = "保单承保失败通知";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">您投保的"+productName+"承保失败。</p>"
					+ "<p style=\"text-indent:2em;\">请及时致电400-662-9696进行咨询。</p>";
			break;
		case APPLYFOR:
			this.subject = "客户保单申请通知";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">有新订单生成(产品："+productName+")！请及时登录保险保函网（<a href='http://www.bailianbao.cn' target='_blank'>http://www.bailianbao.cn</a>）进行查看。</p>";
			break;
		case DECLINATURE:
			this.subject = "订单拒保通知";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">订单号为："+policyNum+"订单(产品："+productName+")保险公司已拒保！请及时登录保险保函网（<a href='http://www.bailianbao.cn' target='_blank'>http://www.bailianbao.cn</a>）进行查看。</p>";
			break;
		case PASSUNDERWRITING:
			this.subject = "保单核保通过通知";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">保险公司已核保通过，请及时登录保险保函网（<a href='http://www.bailianbao.cn' target='_blank'>http://www.bailianbao.cn</a>）进行查看。</p>";
			break;
		case ACCOUNTPAID:
			this.subject = "保单完成缴费通知";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">用户已缴费，请及时登录保险保函网（<a href='http://www.bailianbao.cn' target='_blank'>http://www.bailianbao.cn</a>）进行查看。</p>";
			break;
		case UPLOADBACKLETTER:
			this.subject = "保单保函上传通知";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">保险公司已上传保单、保函，请及时登录保险保函网（<a href='http://www.bailianbao.cn' target='_blank'>http://www.bailianbao.cn</a>）进行查看。</p>";
			break;
		default:
			break;
		}
	}
	
	public EmailModel( EmailMsgType type) {
		switch (type) {
		case INSURE_POLICY:
			this.subject = "报案";
			this.content = "<font color=\"#F18C1E\" style=\"font-family: '黑体';\">尊敬的客户，您好：</font><br>&nbsp;&nbsp;&nbsp;&nbsp;"
					+ "<p style=\"text-indent:2em;\">您投保的</p>"
					+ "<p style=\"text-indent:2em;\">如有疑问，请致电400-662-9696咨询。</p>";
			break;
		default:
			break;
		}
	}
	
	
	
	
	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getEmailType() {
		return emailType;
	}

	public void setEmailType(String emailType) {
		this.emailType = emailType;
	}

	public List<String> getTo() {
		return to;
	}

	public void setTo(List<String> to) {
		this.to = to;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public List<String> getFilePath() {
		return filePath;
	}

	public void setFilePath(List<String> filePath) {
		this.filePath = filePath;
	}

	public void addTo(String email) {
		if(this.to == null) {
			this.to = new ArrayList<String>();
		}
		this.to.add(email);
	}

	public void addFilePath(String filePath) {
		if(this.filePath == null) {
			this.filePath = new ArrayList<String>();
		}
		this.filePath.add(filePath);
	}

	public List<String> getCc() {
		return cc;
	}

	public void setCc(List<String> cc) {
		this.cc = cc;
	}

	public List<String> getBcc() {
		return bcc;
	}

	public void setBcc(List<String> bcc) {
		this.bcc = bcc;
	}
	
	
}
