package com.bcxin.rest.fee.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.common.dto.AjaxResult;
import com.bcxin.common.mapper.JsonMapper;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.models.fee.entity.FeeSettlementMonth;
import com.bcxin.models.fee.service.IFeeSettlementMonthService;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;


/**
 * 月结单
 * @author lyq
 */
@Controller
@RequestMapping("${apiPath}/webFeeMonth")
public class FeeMonthController extends BaseController {



    @Autowired
    private IFeeSettlementMonthService feeSettlementMonthService;

    /**
     * 结算接收接口
     */
    @RequestMapping("/receiveMonthData")
    @ResponseBody
    public AjaxResult receiveFeeSettlementData(HttpServletRequest request){
        String data = request.getParameter("monthData");
        if(StrUtil.isBlank(data)){
            return fail(false,"没有接收到数据");
        }
        List<FeeSettlementMonth> feeMonthList = Lists.newArrayList();
        List<Map<String,Object>> list = (List<Map<String, Object>>) JsonMapper.fromJsonString(data,List.class);
        logger.info("接口获得的数据列表是："+JSON.toJSONString(list));
        if(list.size()>0){
            for(Map<String,Object> map:list) {
                FeeSettlementMonth f= (FeeSettlementMonth) JsonMapper.fromJsonString(JsonMapper.toJsonString(map),FeeSettlementMonth.class);
                //唯一性处理，(产品类型-地区-月份-机构ID) 作为唯一键，保证数据不重复
                List<FeeSettlementMonth> l =  feeSettlementMonthService.selectList(new EntityWrapper<FeeSettlementMonth>().addFilter(
                        "DATE_FORMAT(current_month, '%Y-%m')={0} and product_type={1} and province={2} and cooperation_id={3}",
                        new SimpleDateFormat("yyyy-MM").format(f.getCurrentMonth()),
                        f.getProductType(),
                        f.getProvince(),
                        f.getCooperationId()
                ));
                if(l.size()==0){ //如果数据库中不存在，就插入
                    feeSettlementMonthService.insert(f);
                }else{
                    f.setId(l.get(0).getId());//设置主键，根据查出来的ID去更新
                    feeSettlementMonthService.updateById(f);
                }
//            if(StrUtil.isBlank(beanValidatorAPI(feeSettlementMonth))){
//                FeeSettlementMonth temp = feeSettlementMonthService.selectOne(new EntityWrapper().addFilter("Hxxt_id={0}",feeSettlementMonth.getHxxtId()));
//                if(null!=temp){
//                    feeSettlementMonth.setId(temp.getId());
//                    feeSettlementMonth.setHxxtId(temp.getHxxtId());
//                    feeSettlementMonth.preUpdate();
//                }else {
//                    feeSettlementMonth.preInsert();
//                }
//                feeMonthList.add(feeSettlementMonth);
//            }
            }
        }else{
            return fail(false,"保存失败");
        }

        return success(true,"保存成功["+feeMonthList.size()+"]条数据.保存失败["+(list.size()-feeMonthList.size())+"]条数据");
    }
}
