package com.bcxin.rest.bill.web;

import com.bcxin.common.dto.AjaxResult;
import com.bcxin.common.dto.Result;
import com.bcxin.core.base.web.BaseController;
import com.bcxin.core.entity.SysCompany;
import com.bcxin.core.entity.SysUser;
import com.bcxin.core.service.SysCompanyService;
import com.bcxin.models.fee.entity.FeeSettlement;
import com.bcxin.models.fee.service.FeeSettlementService;
import com.bcxin.models.order.dao.OrderFormDao;
import com.bcxin.mybatisplus.plugins.Page;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.util.StrUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 百联保回传展位投保的情况
 * @apiNote  作者 陈堂君
 * @since 创建于 2018/4/13 17:49
 */
@Controller
@RequestMapping("${apiPath}/blb/")
public class BlbController extends BaseController {

    @Autowired
    private OrderFormDao orderFormDao;

    /**
     * 更新展会保险购买情况
     * @param params 参数  exhibition_hall_pos_string  blb_order_id  blb_product_code  activity_id可先不用，展位目前是唯一，后期可能重复
     * @return
     */
    @RequestMapping("/update-exhibition-ins-info")
    @ResponseBody
    public AjaxResult updateExhibitionInsInfo(@RequestParam Map params){
        try {
            //解析参数 exhibition_hall_pos_string 为 展位，展位，
            orderFormDao.updateExhibitionInsInfo(params);
            //修改订单的项目名
            List<Map> list = orderFormDao.getActivityInfoById(Convert.toStr(params.get("activity_id")));
            if(list.size()>0){
                params.put("activity_name",list.get(0).get("activity_name"));
                orderFormDao.updateOrderByBLBOrderID(params);
            }
        } catch (Exception e) {
            logger.info("获得展位活动信息",e);
            return  new AjaxResult(false,"修改失败");
        }
        return new AjaxResult(true,"修改成功");
    }




}
