/*!
 * qrcode.vue v3.6.0
 * A Vue.js component to generate QRCode. Both support Vue 2 and Vue 3
 * © 2017-PRESENT @scopewu(https://github.com/scopewu)
 * MIT License.
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("vue")):"function"==typeof define&&define.amd?define(["exports","vue"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).QrcodeVue={},e.Vue)}(this,(function(e,t){"use strict";var r,n=function(){return n=Object.assign||function(e){for(var t,r=1,n=arguments.length;n>r;r++)for(var o in t=arguments[r])Object.prototype.hasOwnProperty.call(t,o)&&(e[o]=t[o]);return e},n.apply(this,arguments)};"function"==typeof SuppressedError&&SuppressedError,function(e){var t=function(){function t(e,r,n,i){if(this.version=e,this.errorCorrectionLevel=r,this.modules=[],this.isFunction=[],t.MIN_VERSION>e||e>t.MAX_VERSION)throw new RangeError("Version value out of range");if(-1>i||i>7)throw new RangeError("Mask value out of range");this.size=4*e+17;for(var a=[],s=0;this.size>s;s++)a.push(!1);for(s=0;this.size>s;s++)this.modules.push(a.slice()),this.isFunction.push(a.slice());this.drawFunctionPatterns();var u=this.addEccAndInterleave(n);if(this.drawCodewords(u),-1==i){var h=1e9;for(s=0;8>s;s++){this.applyMask(s),this.drawFormatBits(s);var l=this.getPenaltyScore();h>l&&(i=s,h=l),this.applyMask(s)}}o(i>=0&&7>=i),this.mask=i,this.applyMask(i),this.drawFormatBits(i),this.isFunction=[]}return t.encodeText=function(r,n){var o=e.QrSegment.makeSegments(r);return t.encodeSegments(o,n)},t.encodeBinary=function(r,n){var o=e.QrSegment.makeBytes(r);return t.encodeSegments([o],n)},t.encodeSegments=function(e,n,a,s,u,h){if(void 0===a&&(a=1),void 0===s&&(s=40),void 0===u&&(u=-1),void 0===h&&(h=!0),t.MIN_VERSION>a||a>s||s>t.MAX_VERSION||-1>u||u>7)throw new RangeError("Invalid value");var l,d;for(l=a;;l++){var f=8*t.getNumDataCodewords(l,n),c=i.getTotalBits(e,l);if(f>=c){d=c;break}if(l>=s)throw new RangeError("Data too long")}for(var g=0,v=[t.Ecc.MEDIUM,t.Ecc.QUARTILE,t.Ecc.HIGH];v.length>g;g++){var p=v[g];h&&d<=8*t.getNumDataCodewords(l,p)&&(n=p)}for(var m=[],E=0,C=e;C.length>E;E++){var y=C[E];r(y.mode.modeBits,4,m),r(y.numChars,y.mode.numCharCountBits(l),m);for(var w=0,M=y.getData();M.length>w;w++){m.push(M[w])}}o(m.length==d);var R=8*t.getNumDataCodewords(l,n);o(R>=m.length),r(0,Math.min(4,R-m.length),m),r(0,(8-m.length%8)%8,m),o(m.length%8==0);for(var S=236;R>m.length;S^=253)r(S,8,m);for(var N=[];m.length>8*N.length;)N.push(0);return m.forEach((function(e,t){return N[t>>>3]|=e<<7-(7&t)})),new t(l,n,N,u)},t.prototype.getModule=function(e,t){return e>=0&&this.size>e&&t>=0&&this.size>t&&this.modules[t][e]},t.prototype.getModules=function(){return this.modules},t.prototype.drawFunctionPatterns=function(){for(var e=0;this.size>e;e++)this.setFunctionModule(6,e,e%2==0),this.setFunctionModule(e,6,e%2==0);this.drawFinderPattern(3,3),this.drawFinderPattern(this.size-4,3),this.drawFinderPattern(3,this.size-4);var t=this.getAlignmentPatternPositions(),r=t.length;for(e=0;r>e;e++)for(var n=0;r>n;n++)0==e&&0==n||0==e&&n==r-1||e==r-1&&0==n||this.drawAlignmentPattern(t[e],t[n]);this.drawFormatBits(0),this.drawVersion()},t.prototype.drawFormatBits=function(e){for(var t=this.errorCorrectionLevel.formatBits<<3|e,r=t,i=0;10>i;i++)r=r<<1^1335*(r>>>9);var a=21522^(t<<10|r);o(a>>>15==0);for(i=0;5>=i;i++)this.setFunctionModule(8,i,n(a,i));this.setFunctionModule(8,7,n(a,6)),this.setFunctionModule(8,8,n(a,7)),this.setFunctionModule(7,8,n(a,8));for(i=9;15>i;i++)this.setFunctionModule(14-i,8,n(a,i));for(i=0;8>i;i++)this.setFunctionModule(this.size-1-i,8,n(a,i));for(i=8;15>i;i++)this.setFunctionModule(8,this.size-15+i,n(a,i));this.setFunctionModule(8,this.size-8,!0)},t.prototype.drawVersion=function(){if(this.version>=7){for(var e=this.version,t=0;12>t;t++)e=e<<1^7973*(e>>>11);var r=this.version<<12|e;o(r>>>18==0);for(t=0;18>t;t++){var i=n(r,t),a=this.size-11+t%3,s=Math.floor(t/3);this.setFunctionModule(a,s,i),this.setFunctionModule(s,a,i)}}},t.prototype.drawFinderPattern=function(e,t){for(var r=-4;4>=r;r++)for(var n=-4;4>=n;n++){var o=Math.max(Math.abs(n),Math.abs(r)),i=e+n,a=t+r;i>=0&&this.size>i&&a>=0&&this.size>a&&this.setFunctionModule(i,a,2!=o&&4!=o)}},t.prototype.drawAlignmentPattern=function(e,t){for(var r=-2;2>=r;r++)for(var n=-2;2>=n;n++)this.setFunctionModule(e+n,t+r,1!=Math.max(Math.abs(n),Math.abs(r)))},t.prototype.setFunctionModule=function(e,t,r){this.modules[t][e]=r,this.isFunction[t][e]=!0},t.prototype.addEccAndInterleave=function(e){var r=this.version,n=this.errorCorrectionLevel;if(e.length!=t.getNumDataCodewords(r,n))throw new RangeError("Invalid argument");for(var i=t.NUM_ERROR_CORRECTION_BLOCKS[n.ordinal][r],a=t.ECC_CODEWORDS_PER_BLOCK[n.ordinal][r],s=Math.floor(t.getNumRawDataModules(r)/8),u=i-s%i,h=Math.floor(s/i),l=[],d=t.reedSolomonComputeDivisor(a),f=0,c=0;i>f;f++){var g=e.slice(c,c+h-a+(u>f?0:1));c+=g.length;var v=t.reedSolomonComputeRemainder(g,d);u>f&&g.push(0),l.push(g.concat(v))}var p=[],m=function(e){l.forEach((function(t,r){e==h-a&&u>r||p.push(t[e])}))};for(f=0;l[0].length>f;f++)m(f);return o(p.length==s),p},t.prototype.drawCodewords=function(e){if(e.length!=Math.floor(t.getNumRawDataModules(this.version)/8))throw new RangeError("Invalid argument");for(var r=0,i=this.size-1;i>=1;i-=2){6==i&&(i=5);for(var a=0;this.size>a;a++)for(var s=0;2>s;s++){var u=i-s,h=!(i+1&2)?this.size-1-a:a;!this.isFunction[h][u]&&8*e.length>r&&(this.modules[h][u]=n(e[r>>>3],7-(7&r)),r++)}}o(r==8*e.length)},t.prototype.applyMask=function(e){if(0>e||e>7)throw new RangeError("Mask value out of range");for(var t=0;this.size>t;t++)for(var r=0;this.size>r;r++){var n=void 0;switch(e){case 0:n=(r+t)%2==0;break;case 1:n=t%2==0;break;case 2:n=r%3==0;break;case 3:n=(r+t)%3==0;break;case 4:n=(Math.floor(r/3)+Math.floor(t/2))%2==0;break;case 5:n=r*t%2+r*t%3==0;break;case 6:n=(r*t%2+r*t%3)%2==0;break;case 7:n=((r+t)%2+r*t%3)%2==0;break;default:throw Error("Unreachable")}!this.isFunction[t][r]&&n&&(this.modules[t][r]=!this.modules[t][r])}},t.prototype.getPenaltyScore=function(){for(var e=0,r=0;this.size>r;r++){for(var n=!1,i=0,a=[0,0,0,0,0,0,0],s=0;this.size>s;s++)this.modules[r][s]==n?5==++i?e+=t.PENALTY_N1:i>5&&e++:(this.finderPenaltyAddHistory(i,a),n||(e+=this.finderPenaltyCountPatterns(a)*t.PENALTY_N3),n=this.modules[r][s],i=1);e+=this.finderPenaltyTerminateAndCount(n,i,a)*t.PENALTY_N3}for(s=0;this.size>s;s++){n=!1;var u=0;for(a=[0,0,0,0,0,0,0],r=0;this.size>r;r++)this.modules[r][s]==n?5==++u?e+=t.PENALTY_N1:u>5&&e++:(this.finderPenaltyAddHistory(u,a),n||(e+=this.finderPenaltyCountPatterns(a)*t.PENALTY_N3),n=this.modules[r][s],u=1);e+=this.finderPenaltyTerminateAndCount(n,u,a)*t.PENALTY_N3}for(r=0;this.size-1>r;r++)for(s=0;this.size-1>s;s++){var h=this.modules[r][s];h==this.modules[r][s+1]&&h==this.modules[r+1][s]&&h==this.modules[r+1][s+1]&&(e+=t.PENALTY_N2)}for(var l=0,d=0,f=this.modules;f.length>d;d++){l=f[d].reduce((function(e,t){return e+(t?1:0)}),l)}var c=this.size*this.size,g=Math.ceil(Math.abs(20*l-10*c)/c)-1;return o(g>=0&&9>=g),o((e+=g*t.PENALTY_N4)>=0&&2568888>=e),e},t.prototype.getAlignmentPatternPositions=function(){if(1==this.version)return[];for(var e=Math.floor(this.version/7)+2,t=2*Math.floor((8*this.version+3*e+5)/(4*e-4)),r=[6],n=this.size-7;e>r.length;n-=t)r.splice(1,0,n);return r},t.getNumRawDataModules=function(e){if(t.MIN_VERSION>e||e>t.MAX_VERSION)throw new RangeError("Version number out of range");var r=(16*e+128)*e+64;if(e>=2){var n=Math.floor(e/7)+2;r-=(25*n-10)*n-55,7>e||(r-=36)}return o(r>=208&&29648>=r),r},t.getNumDataCodewords=function(e,r){return Math.floor(t.getNumRawDataModules(e)/8)-t.ECC_CODEWORDS_PER_BLOCK[r.ordinal][e]*t.NUM_ERROR_CORRECTION_BLOCKS[r.ordinal][e]},t.reedSolomonComputeDivisor=function(e){if(1>e||e>255)throw new RangeError("Degree out of range");for(var r=[],n=0;e-1>n;n++)r.push(0);r.push(1);var o=1;for(n=0;e>n;n++){for(var i=0;r.length>i;i++)r[i]=t.reedSolomonMultiply(r[i],o),r.length>i+1&&(r[i]^=r[i+1]);o=t.reedSolomonMultiply(o,2)}return r},t.reedSolomonComputeRemainder=function(e,r){for(var n=r.map((function(e){return 0})),o=function(e){var o=e^n.shift();n.push(0),r.forEach((function(e,r){return n[r]^=t.reedSolomonMultiply(e,o)}))},i=0,a=e;a.length>i;i++){o(a[i])}return n},t.reedSolomonMultiply=function(e,t){if(e>>>8!=0||t>>>8!=0)throw new RangeError("Byte out of range");for(var r=0,n=7;n>=0;n--)r=r<<1^285*(r>>>7),r^=(t>>>n&1)*e;return o(r>>>8==0),r},t.prototype.finderPenaltyCountPatterns=function(e){var t=e[1];o(3*this.size>=t);var r=t>0&&e[2]==t&&e[3]==3*t&&e[4]==t&&e[5]==t;return(!r||4*t>e[0]||t>e[6]?0:1)+(!r||4*t>e[6]||t>e[0]?0:1)},t.prototype.finderPenaltyTerminateAndCount=function(e,t,r){return e&&(this.finderPenaltyAddHistory(t,r),t=0),this.finderPenaltyAddHistory(t+=this.size,r),this.finderPenaltyCountPatterns(r)},t.prototype.finderPenaltyAddHistory=function(e,t){0==t[0]&&(e+=this.size),t.pop(),t.unshift(e)},t.MIN_VERSION=1,t.MAX_VERSION=40,t.PENALTY_N1=3,t.PENALTY_N2=3,t.PENALTY_N3=40,t.PENALTY_N4=10,t.ECC_CODEWORDS_PER_BLOCK=[[-1,7,10,15,20,26,18,20,24,30,18,20,24,26,30,22,24,28,30,28,28,28,28,30,30,26,28,30,30,30,30,30,30,30,30,30,30,30,30,30,30],[-1,10,16,26,18,24,16,18,22,22,26,30,22,22,24,24,28,28,26,26,26,26,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28],[-1,13,22,18,26,18,24,18,22,20,24,28,26,24,20,30,24,28,28,26,30,28,30,30,30,30,28,30,30,30,30,30,30,30,30,30,30,30,30,30,30],[-1,17,28,22,16,22,28,26,26,24,28,24,28,22,24,24,30,28,28,26,28,30,24,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30]],t.NUM_ERROR_CORRECTION_BLOCKS=[[-1,1,1,1,1,1,2,2,2,2,4,4,4,4,4,6,6,6,6,7,8,8,9,9,10,12,12,12,13,14,15,16,17,18,19,19,20,21,22,24,25],[-1,1,1,1,2,2,4,4,4,5,5,5,8,9,9,10,10,11,13,14,16,17,17,18,20,21,23,25,26,28,29,31,33,35,37,38,40,43,45,47,49],[-1,1,1,2,2,4,4,6,6,8,8,8,10,12,16,12,17,16,18,21,20,23,23,25,27,29,34,34,35,38,40,43,45,48,51,53,56,59,62,65,68],[-1,1,1,2,4,4,4,5,6,8,8,11,11,16,16,18,16,19,21,25,25,25,34,30,32,35,37,40,42,45,48,51,54,57,60,63,66,70,74,77,81]],t}();function r(e,t,r){if(0>t||t>31||e>>>t!=0)throw new RangeError("Value out of range");for(var n=t-1;n>=0;n--)r.push(e>>>n&1)}function n(e,t){return!!(e>>>t&1)}function o(e){if(!e)throw Error("Assertion error")}e.QrCode=t;var i=function(){function e(e,t,r){if(this.mode=e,this.numChars=t,this.bitData=r,0>t)throw new RangeError("Invalid argument");this.bitData=r.slice()}return e.makeBytes=function(t){for(var n=[],o=0,i=t;i.length>o;o++){r(i[o],8,n)}return new e(e.Mode.BYTE,t.length,n)},e.makeNumeric=function(t){if(!e.isNumeric(t))throw new RangeError("String contains non-numeric characters");for(var n=[],o=0;t.length>o;){var i=Math.min(t.length-o,3);r(parseInt(t.substring(o,o+i),10),3*i+1,n),o+=i}return new e(e.Mode.NUMERIC,t.length,n)},e.makeAlphanumeric=function(t){if(!e.isAlphanumeric(t))throw new RangeError("String contains unencodable characters in alphanumeric mode");var n,o=[];for(n=0;t.length>=n+2;n+=2){var i=45*e.ALPHANUMERIC_CHARSET.indexOf(t.charAt(n));r(i+=e.ALPHANUMERIC_CHARSET.indexOf(t.charAt(n+1)),11,o)}return t.length>n&&r(e.ALPHANUMERIC_CHARSET.indexOf(t.charAt(n)),6,o),new e(e.Mode.ALPHANUMERIC,t.length,o)},e.makeSegments=function(t){return""==t?[]:e.isNumeric(t)?[e.makeNumeric(t)]:e.isAlphanumeric(t)?[e.makeAlphanumeric(t)]:[e.makeBytes(e.toUtf8ByteArray(t))]},e.makeEci=function(t){var n=[];if(0>t)throw new RangeError("ECI assignment value out of range");if(128>t)r(t,8,n);else if(16384>t)r(2,2,n),r(t,14,n);else{if(t>=1e6)throw new RangeError("ECI assignment value out of range");r(6,3,n),r(t,21,n)}return new e(e.Mode.ECI,0,n)},e.isNumeric=function(t){return e.NUMERIC_REGEX.test(t)},e.isAlphanumeric=function(t){return e.ALPHANUMERIC_REGEX.test(t)},e.prototype.getData=function(){return this.bitData.slice()},e.getTotalBits=function(e,t){for(var r=0,n=0,o=e;o.length>n;n++){var i=o[n],a=i.mode.numCharCountBits(t);if(i.numChars>=1<<a)return 1/0;r+=4+a+i.bitData.length}return r},e.toUtf8ByteArray=function(e){e=encodeURI(e);for(var t=[],r=0;e.length>r;r++)"%"!=e.charAt(r)?t.push(e.charCodeAt(r)):(t.push(parseInt(e.substring(r+1,r+3),16)),r+=2);return t},e.NUMERIC_REGEX=/^[0-9]*$/,e.ALPHANUMERIC_REGEX=/^[A-Z0-9 $%*+.\/:-]*$/,e.ALPHANUMERIC_CHARSET="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:",e}();e.QrSegment=i}(r||(r={})),function(e){var t,r;t=e.QrCode||(e.QrCode={}),r=function(){function e(e,t){this.ordinal=e,this.formatBits=t}return e.LOW=new e(0,1),e.MEDIUM=new e(1,0),e.QUARTILE=new e(2,3),e.HIGH=new e(3,2),e}(),t.Ecc=r}(r||(r={})),function(e){var t,r;t=e.QrSegment||(e.QrSegment={}),r=function(){function e(e,t){this.modeBits=e,this.numBitsCharCount=t}return e.prototype.numCharCountBits=function(e){return this.numBitsCharCount[Math.floor((e+7)/17)]},e.NUMERIC=new e(1,[10,12,14]),e.ALPHANUMERIC=new e(2,[9,11,13]),e.BYTE=new e(4,[8,16,16]),e.KANJI=new e(8,[8,10,12]),e.ECI=new e(7,[0,0,0]),e}(),t.Mode=r}(r||(r={}));var o=r,i={L:o.QrCode.Ecc.LOW,M:o.QrCode.Ecc.MEDIUM,Q:o.QrCode.Ecc.QUARTILE,H:o.QrCode.Ecc.HIGH},a=function(){try{(new Path2D).addPath(new Path2D)}catch(e){return!1}return!0}();function s(e){return e in i}function u(e,t){void 0===t&&(t=0);var r=[];return e.forEach((function(e,n){var o=null;e.forEach((function(i,a){if(!i&&null!==o)return r.push("M".concat(o+t," ").concat(n+t,"h").concat(a-o,"v1H").concat(o+t,"z")),void(o=null);if(a!==e.length-1)i&&null===o&&(o=a);else{if(!i)return;r.push(null===o?"M".concat(a+t,",").concat(n+t," h1v1H").concat(a+t,"z"):"M".concat(o+t,",").concat(n+t," h").concat(a+1-o,"v1H").concat(o+t,"z"))}}))})),r.join("")}function h(e,t,r,n){var o=n.width,i=n.height,a=n.x,s=n.y,u=e.length+2*r,h=Math.floor(.1*t),l=u/t,d=(o||h)*l,f=(i||h)*l,c=null==a?e.length/2-d/2:a*l,g=null==s?e.length/2-f/2:s*l,v=null;if(n.excavate){var p=Math.floor(c),m=Math.floor(g);v={x:p,y:m,w:Math.ceil(d+c-p),h:Math.ceil(f+g-m)}}return{x:c,y:g,h:f,w:d,excavation:v}}function l(e,t){return e.slice().map((function(e,r){return t.y>r||r>=t.y+t.h?e:e.map((function(e,r){return(t.x>r||r>=t.x+t.w)&&e}))}))}var d={value:{type:String,required:!0,default:""},size:{type:Number,default:100},level:{type:String,default:"L",validator:function(e){return s(e)}},background:{type:String,default:"#fff"},foreground:{type:String,default:"#000"},margin:{type:Number,required:!1,default:0},imageSettings:{type:Object,required:!1,default:function(){return{}}},gradient:{type:Boolean,required:!1,default:!1},gradientType:{type:String,required:!1,default:"linear",validator:function(e){return["linear","radial"].indexOf(e)>-1}},gradientStartColor:{type:String,required:!1,default:"#000"},gradientEndColor:{type:String,required:!1,default:"#fff"}},f=n(n({},d),{renderAs:{type:String,required:!1,default:"canvas",validator:function(e){return["canvas","svg"].indexOf(e)>-1}}}),c=t.defineComponent({name:"QRCodeSvg",props:d,setup:function(e){var r,a=t.ref(0),d=t.ref(""),f=function(){var t=e.value,n=e.level,f=e.margin>>>0,c=s(n)?n:"L",g=o.QrCode.encodeText(t,i[c]).getModules();if(a.value=g.length+2*f,e.imageSettings.src){var v=h(g,e.size,f,e.imageSettings);r={x:v.x+f,y:v.y+f,width:v.w,height:v.h},v.excavation&&(g=l(g,v.excavation))}d.value=u(g,f)};return f(),t.onUpdated(f),function(){return t.h("svg",{width:e.size,height:e.size,"shape-rendering":"crispEdges",xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 ".concat(a.value," ").concat(a.value)},[t.h("defs",{},[e.gradient?t.h("linear"===e.gradientType?"linearGradient":"radialGradient",n({id:"qr-gradient"},"linear"===e.gradientType?{x1:"0%",y1:"0%",x2:"100%",y2:"100%"}:{cx:"50%",cy:"50%",r:"50%",fx:"50%",fy:"50%"}),[t.h("stop",{offset:"0%",style:{stopColor:e.gradientStartColor}}),t.h("stop",{offset:"100%",style:{stopColor:e.gradientEndColor}})]):null]),t.h("rect",{width:"100%",height:"100%",fill:e.background}),t.h("path",{fill:e.gradient?"url(#qr-gradient)":e.foreground,d:d.value}),e.imageSettings.src&&t.h("image",n({href:e.imageSettings.src},r))])}}}),g=t.defineComponent({name:"QRCodeCanvas",props:d,setup:function(e,r){var d=t.ref(null),f=t.ref(null),c=function(){var t=e.value,r=e.level,n=e.size,c=e.background,g=e.foreground,v=e.gradient,p=e.gradientType,m=e.gradientStartColor,E=e.gradientEndColor,C=e.margin>>>0,y=s(r)?r:"L",w=d.value;if(w){var M=w.getContext("2d");if(M){var R=o.QrCode.encodeText(t,i[y]).getModules(),S=R.length+2*C,N=f.value,A={x:0,y:0,width:0,height:0},P=e.imageSettings.src&&null!=N&&0!==N.naturalWidth&&0!==N.naturalHeight;if(P){var I=h(R,e.size,C,e.imageSettings);A={x:I.x+C,y:I.y+C,width:I.w,height:I.h},I.excavation&&(R=l(R,I.excavation))}var _=window.devicePixelRatio||1,z=n/S*_;if(w.height=w.width=n*_,M.scale(z,z),M.fillStyle=c,M.fillRect(0,0,S,S),v){var O=void 0;(O="linear"===p?M.createLinearGradient(0,0,S,S):M.createRadialGradient(S/2,S/2,0,S/2,S/2,S/2)).addColorStop(0,m),O.addColorStop(1,E),M.fillStyle=O}else M.fillStyle=g;a?M.fill(new Path2D(u(R,C))):R.forEach((function(e,t){e.forEach((function(e,r){e&&M.fillRect(r+C,t+C,1,1)}))})),P&&M.drawImage(N,A.x,A.y,A.width,A.height)}}};t.onMounted(c),t.onUpdated(c);var g=r.attrs.style;return function(){return t.h(t.Fragment,[t.h("canvas",n(n({},r.attrs),{ref:d,style:n(n({},g),{width:"".concat(e.size,"px"),height:"".concat(e.size,"px")})})),e.imageSettings.src&&t.h("img",{ref:f,src:e.imageSettings.src,style:{display:"none"},onLoad:c})])}}}),v=t.defineComponent({name:"Qrcode",render:function(){var e=this.$props;return t.h("svg"===e.renderAs?c:g,{value:e.value,size:e.size,margin:e.margin,level:e.level,background:e.background,foreground:e.foreground,imageSettings:e.imageSettings,gradient:e.gradient,gradientType:e.gradientType,gradientStartColor:e.gradientStartColor,gradientEndColor:e.gradientEndColor})},props:f});e.QrcodeCanvas=g,e.QrcodeSvg=c,e.default=v,Object.defineProperty(e,"__esModule",{value:!0})}));
