import { a as legacyRootDirArgs, i as extendsArgs, n as dotEnvArgs, o as logLevelArgs, r as envNameArgs, t as cwdArgs } from "./_shared-C3vB2YLc.mjs";
import { t as logger } from "./logger-Dk0gkCkX.mjs";
import { t as loadKit } from "./kit-f7zsnm10.mjs";
import { t as showVersions } from "./banner-CWBLwDiB.mjs";
import { t as clearBuildDir } from "./fs--ofMleGo.mjs";
import { t as overrideEnv } from "./env-CamzysGq.mjs";
import process from "node:process";
import { defineCommand } from "citty";
import { relative, resolve } from "pathe";

//#region ../nuxi/src/commands/build.ts
var build_default = defineCommand({
	meta: {
		name: "build",
		description: "Build Nuxt for production deployment"
	},
	args: {
		...cwdArgs,
		...logLevelArgs,
		prerender: {
			type: "boolean",
			description: "Build Nuxt and prerender static routes"
		},
		preset: {
			type: "string",
			description: "Nitro server preset"
		},
		...dotEnvArgs,
		...envNameArgs,
		...extendsArgs,
		...legacyRootDirArgs
	},
	async run(ctx) {
		overrideEnv("production");
		const cwd = resolve(ctx.args.cwd || ctx.args.rootDir);
		const kit = await loadKit(cwd);
		await showVersions(cwd, kit);
		const nuxt = await kit.loadNuxt({
			cwd,
			dotenv: {
				cwd,
				fileName: ctx.args.dotenv
			},
			envName: ctx.args.envName,
			overrides: {
				logLevel: ctx.args.logLevel,
				_generate: ctx.args.prerender,
				nitro: {
					static: ctx.args.prerender,
					preset: ctx.args.preset || process.env.NITRO_PRESET || process.env.SERVER_PRESET
				},
				...ctx.args.extends && { extends: ctx.args.extends },
				...ctx.data?.overrides
			}
		});
		let nitro;
		try {
			nitro = kit.useNitro?.();
			if (nitro) logger.info(`Building for Nitro preset: \`${nitro.options.preset}\``);
		} catch {}
		await clearBuildDir(nuxt.options.buildDir);
		await kit.writeTypes(nuxt);
		nuxt.hook("build:error", (err) => {
			logger.error("Nuxt Build Error:", err);
			process.exit(1);
		});
		await kit.buildNuxt(nuxt);
		if (ctx.args.prerender) {
			if (!nuxt.options.ssr) logger.warn("HTML content not prerendered because `ssr: false` was set. You can read more in `https://nuxt.com/docs/getting-started/deployment#static-hosting`.");
			const dir = nitro?.options.output.publicDir;
			const publicDir = dir ? relative(process.cwd(), dir) : ".output/public";
			logger.success(`You can now deploy \`${publicDir}\` to any static hosting!`);
		}
	}
});

//#endregion
export { build_default as t };