import * as vite from 'vite';
import { Plugin } from 'vite';
import { UserConfig, UnocssPluginContext, UnoGenerator, UserConfigDefaults } from '@unocss/core';

interface VitePluginConfig<Theme extends {} = {}> extends UserConfig<Theme> {
    /**
     * Enable UnoCSS inspector
     *
     * @default true
     */
    inspector?: boolean;
    /**
     * CSS Generation mode
     *
     * - `global` - generate a single CSS sheet for entire App
     * - `dist-chunk` - generate a CSS sheet for each code chunk on build, great for MPA
     * - `per-module` - generate a CSS sheet for each module, can be scoped
     * - `vue-scoped` - inject generated CSS to Vue SFC's `<style scoped>` for isolation
     * - `svelte-scoped` - inject generated CSS to Svelte's `<style>` for isolation
     * - `shadow-dom` - inject generated CSS to `Shadow DOM` css style block for each web component
     *
     * @default 'global'
     */
    mode?: 'global' | 'per-module' | 'vue-scoped' | 'svelte-scoped' | 'dist-chunk' | 'shadow-dom';
    /**
     * Transform CSS for `@apply` directive
     *
     * @experimental
     * @default false
     */
    transformCSS?: boolean | 'pre' | 'post';
    /**
     * Make the generated css processed by postcss (https://vitejs.dev/guide/features.html#postcss)
     *
     * @default true
     */
    postcss?: boolean;
    /**
     * Use top level await in HMR code to avoid FOUC on dev time.
     *
     * You usually don't need to disable this, unless you are developing on
     * a browser that does not support top level await.
     *
     * This will only affect on dev time.
     *
     * @default true
     */
    hmrTopLevelAwait?: boolean;
}

declare function ChunkModeBuildPlugin({ uno, filter }: UnocssPluginContext): Plugin;

declare function GlobalModeDevPlugin({ uno, tokens, tasks, flushTasks, affectedModules, onInvalidate, extract, filter, getConfig }: UnocssPluginContext): Plugin[];

declare function GlobalModeBuildPlugin(ctx: UnocssPluginContext<VitePluginConfig>): Plugin[];

declare function GlobalModePlugin(ctx: UnocssPluginContext): vite.Plugin[];

declare function PerModuleModePlugin({ uno, filter }: UnocssPluginContext): Plugin[];

declare function VueScopedPlugin({ uno, ready }: UnocssPluginContext): Plugin;

interface TransformSFCOptions {
    /**
     * Prefix for compiled class name
     * @default 'uno-'
     */
    classPrefix?: string;
    /**
     * Add hash and combine recognized tokens (optimal for production); set false in dev mode for easy dev tools toggling to allow for design adjustments in the browser
     * @default true
     */
    combine?: boolean;
    /**
     * Hash function
     */
    hashFn?: (str: string) => string;
}
declare function transformSvelteSFC(code: string, id: string, uno: UnoGenerator, options?: TransformSFCOptions): Promise<{
    code: string;
    map?: SourceMap;
} | undefined>;
interface SourceMap {
    file: string;
    mappings: string;
    names: string[];
    sources: string[];
    sourcesContent: string[];
    version: number;
    toString(): string;
    toUrl(): string;
}

declare function SvelteScopedPlugin({ ready, uno }: UnocssPluginContext): Plugin;

declare function defineConfig<Theme extends {}>(config: VitePluginConfig<Theme>): VitePluginConfig<Theme>;
declare function UnocssPlugin<Theme extends {}>(configOrPath?: VitePluginConfig<Theme> | string, defaults?: UserConfigDefaults): Plugin[];

export { ChunkModeBuildPlugin, GlobalModeBuildPlugin, GlobalModeDevPlugin, GlobalModePlugin, PerModuleModePlugin, SvelteScopedPlugin, TransformSFCOptions, VitePluginConfig, VueScopedPlugin, UnocssPlugin as default, defineConfig, transformSvelteSFC };
