import { c as createCDNLoader, l as loadIcon } from './shared/preset-icons.75f9a7c9.mjs';
import { createPresetIcons, combineLoaders } from './core.mjs';
export { combineLoaders, createPresetIcons } from './core.mjs';
import 'ofetch';
import '@unocss/core';

const isNode = typeof process < "u" && typeof process.stdout < "u" && !process.versions.deno;
const isVSCode = isNode && !!process.env.VSCODE_CWD;

async function createNodeLoader() {
  try {
    return await import('@iconify/utils/lib/loader/node-loader').then((i) => i?.loadNodeIcon);
  } catch {
  }
  try {
    return require("@iconify/utils/lib/loader/node-loader.cjs");
  } catch {
  }
}
const presetIcons = createPresetIcons(async (options) => {
  const {
    cdn
  } = options;
  const loaders = [];
  if (isNode && !isVSCode)
    loaders.push(await createNodeLoader());
  if (cdn)
    loaders.push(createCDNLoader(cdn));
  loaders.push(loadIcon);
  return combineLoaders(loaders);
});

export { presetIcons as default, presetIcons };
