'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const cdn = require('./shared/preset-icons.24e4d94c.cjs');
const core = require('./core.cjs');
require('ofetch');
require('@unocss/core');

const isNode = typeof process < "u" && typeof process.stdout < "u" && !process.versions.deno;
const isVSCode = isNode && !!process.env.VSCODE_CWD;

async function createNodeLoader() {
  try {
    return await import('@iconify/utils/lib/loader/node-loader').then((i) => i?.loadNodeIcon);
  } catch {
  }
  try {
    return require("@iconify/utils/lib/loader/node-loader.cjs");
  } catch {
  }
}
const presetIcons = core.createPresetIcons(async (options) => {
  const {
    cdn: cdn$1
  } = options;
  const loaders = [];
  if (isNode && !isVSCode)
    loaders.push(await createNodeLoader());
  if (cdn$1)
    loaders.push(cdn.createCDNLoader(cdn$1));
  loaders.push(cdn.loadIcon);
  return core.combineLoaders(loaders);
});

exports.combineLoaders = core.combineLoaders;
exports.createPresetIcons = core.createPresetIcons;
exports["default"] = presetIcons;
exports.presetIcons = presetIcons;
