'use strict';

const node_path = require('node:path');
const node_url = require('node:url');
const VitePlugin = require('@unocss/vite');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e["default"] : e; }

const VitePlugin__default = /*#__PURE__*/_interopDefaultLegacy(VitePlugin);

function UnoCSSAstroIntegration(options = {}, defaults) {
  const {
    injectEntry = true,
    injectReset = false,
    injectExtra = []
  } = options;
  return {
    name: "unocss",
    hooks: {
      "astro:config:setup": async ({ config, injectScript }) => {
        var _a, _b;
        options.extraContent || (options.extraContent = {});
        (_a = options.extraContent).filesystem || (_a.filesystem = []);
        options.extraContent.filesystem.push(node_path.resolve(node_url.fileURLToPath(config.srcDir), "components/**/*").replace(/\\/g, "/"));
        (_b = config.vite).plugins || (_b.plugins = []);
        config.vite.plugins.push(...VitePlugin__default(options, defaults));
        const injects = [];
        if (injectReset) {
          const resetPath = typeof injectReset === "string" ? injectReset : "@unocss/reset/tailwind.css";
          injects.push(`import "${resetPath}"`);
        }
        if (injectEntry) {
          injects.push(typeof injectEntry === "string" ? injectEntry : 'import "uno.css"');
        }
        if (injectExtra.length > 0)
          injects.push(...injectExtra);
        if (injects?.length)
          injectScript("page-ssr", injects.join("\n"));
      }
    }
  };
}

module.exports = UnoCSSAstroIntegration;
