package com.bcxin.rbac.domain.services.commands.roles;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class UpdateRoleCommand extends CommandAbstract {
    private final String id;
    private final String name;
    private final Collection<ResourceItem> resources;


    public UpdateRoleCommand(String id,
                             String name,
                             Collection<ResourceItem> resources) {
        this.id = id;
        this.name = name;
        this.resources = resources;
    }

    public static UpdateRoleCommand create(String id,
                                           String name,
                                           Collection<ResourceItem> resources) {
        return new UpdateRoleCommand(id, name, resources);
    }
}
