package com.bcxin.rbac.domain.rm;

import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.rbac.domain.RbacConstant;
import com.bcxin.rbac.domain.entities.MetaEntityAbstract;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;

/**
 * 功能点
 * 用于管理比如: 按钮
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table
@Entity
public class FunctionEntity extends MetaEntityAbstract {
    @Id
    private String id;

    @Column(name = "name", length = 500, nullable = false)
    private String name;

    @Column(nullable = false, name = "online")
    private TrueFalseStatus online;

    /**
     * 功能点/数据权限
     */
    @Column(name = "category", length = 100, nullable = false)
    private String category;

    @ManyToOne
    @JoinColumn(name = "group_id",referencedColumnName = "id",
            foreignKey = @ForeignKey(name = "fk_function_group_id",value = ConstraintMode.CONSTRAINT))
    private GroupEntity group;

    protected FunctionEntity() {
        this.setCategory(RbacConstant.FUNCTION);
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static FunctionEntity create(String name, String metaId, boolean online) {
        FunctionEntity function = new FunctionEntity();
        function.setId(UUIDUtil.getShortUuid());
        function.setMetaId(metaId);
        function.setName(name);
        function.setOnline(online ? TrueFalseStatus.True : TrueFalseStatus.False);

        return function;
    }
}