package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;

/**
 * Rbac系统的用户信息
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "rbac_users")
@Entity
public class UserEntity extends MetaEntityAbstract implements IAggregate {
    @Id
    private String id;

    @ManyToOne
    @JoinColumn(name = "subject_id", referencedColumnName = "id", nullable = false)
    private SubjectEntity subject;

    @OneToMany(mappedBy = "subject")
    private Collection<RoleEntity> roles;

    /**
     * 外部对象的ID, 比如: 用户/租户等
     */
    @Column(name = "referenced_id", length = 100, nullable = false)
    private String referencedId;

    @Column(name = "name", length = 100, nullable = false)
    private String name;

    protected UserEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static UserEntity create(SubjectEntity subject, String referencedId, String name) {
        UserEntity user = new UserEntity();
        user.setId(UUIDUtil.getShortUuid());
        user.setReferencedId(referencedId);
        user.setSubject(subject);
        user.setName(name);

        return user;
    }

    public void assignRoles(Collection<RoleEntity> roles) {
        this.setRoles(roles);
    }
}
