package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.rbac.domain.rm.FunctionEntity;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;

/**
 * 角色信息表
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "rbac_roles")
@Entity
public class RoleEntity extends MetaEntityAbstract implements IAggregate {
    @Id
    private String id;

    @Column(name = "name", length = 200)
    private String name;

    @ManyToOne
    @JoinColumn(name = "subject_id",referencedColumnName = "id",foreignKey = @ForeignKey(name = "fk_role_subject_id",value = ConstraintMode.CONSTRAINT))
    private SubjectEntity subject;

    @OneToMany(cascade = CascadeType.DETACH)
    private Collection<ResourceEntity> resources;

    @OneToMany
    private Collection<UserEntity> users;

    public void change(String name) {
        this.setName(name);
    }

    @Embedded
    private OperatorValueType creator;

    public void assignResources(Collection<ResourceEntity> resources) {
        this.setResources(resources);
    }

    protected RoleEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static RoleEntity create(SubjectEntity subject, String name) {
        RoleEntity role = new RoleEntity();
        role.setSubject(subject);

        role.setId(UUIDUtil.getShortUuid());
        role.setName(name);

        return role;
    }
}
