package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 权限操作项用户关联表
 */
@Data
@Table(name = "rbac_permit_option_user")
@Entity
public class RbacPermitOptionUserEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键id
     */
    @Id
    private Long id;
    /**
     * 企业id
     */
    @Column(name = "organization_id")
    private String organizationId;
    /**
     * 权限应用id
     */
    @Column(name = "permit_app_id")
    private Long permitAppId;
    /**
     * 权限操作项id
     */
    @Column(name = "permit_option_id")
    private Long permitOptionId;
    /**
     * 职员id
     */
    @Column(name = "tenant_employee_id")
    private String tenantEmployeeId;
    /**
     * 应用代码
     */
    @Column(name = "app_code")
    private String appCode;
    /**
     * 操作项类型，1：web，2：app
     */
    @Column(name = "option_type")
    private Integer optionType;
    /**
     * 操作项代码
     */
    @Column(name = "option_code")
    private String optionCode;
    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;
    /**
     * 创建人id
     */
    @Column(name = "create_user_id")
    private String createUserId;
    /**
     * 更新时间
     */
    @Column(name = "update_time")
    private Date updateTime;
    /**
     * 更新人id
     */
    @Column(name = "update_user_id")
    private String updateUserId;


    public static RbacPermitOptionUserEntity create(Long id, String organizationId, Long permitAppId, Long permitOptionId,
                                                    String tenantEmployeeId, String appCode, Integer optionType, String optionCode, String createUserId) {
        RbacPermitOptionUserEntity role = new RbacPermitOptionUserEntity();
        role.setId(id);
        role.setOrganizationId(organizationId);
        role.setPermitAppId(permitAppId);
        role.setPermitOptionId(permitOptionId);
        role.setTenantEmployeeId(tenantEmployeeId);
        role.setAppCode(appCode);
        role.setOptionType(optionType);
        role.setOptionCode(optionCode);
        role.setCreateTime(new Date());
        role.setCreateUserId(createUserId);
        return role;
    }
}
