package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 权限操作项表
 */
@Data
@Table(name = "rbac_permit_option")
@Entity
public class RbacPermitOptionEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键id
     */
    @Id
    private Long id;
    /**
     * 权限应用id
     */
    @Column(name = "permit_app_id")
    private Long permitAppId;
    /**
     * 应用代码/应用id
     */
    @Column(name = "app_code")
    private String appCode;
    /**
     * 操作项分类
     */
    @Column(name = "category")
    private String category;
    /**
     * 操作项类型，1：web，2：app
     */
    @Column(name = "option_type")
    private Integer optionType;
    /**
     * 操作项代码/菜单id
     */
    @Column(name = "option_code")
    private String optionCode;
    /**
     * 操作项名称
     */
    @Column(name = "option_name")
    private String optionName;
    /**
     * 排序
     */
    @Column(name = "seq")
    private Integer seq;

}
