package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

/**
 * 自定义角色用户关联表
 */
@Data
@Table(name = "rbac_custom_role_user")
@Entity
public class RbacCustomRoleUserEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键id
     */
    @Id
    private Long id;
    /**
     * 企业id
     */
    @Column(name = "organization_id")
    private String organizationId;
    /**
     * 角色id
     */
    @Column(name = "rbac_role_id")
    private Long rbacRoleId;
    /**
     * 职员id
     */
    @Column(name = "tenant_employee_id")
    private String tenantEmployeeId;
    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;
    /**
     * 创建人id
     */
    @Column(name = "create_user_id")
    private String createUserId;
    /**
     * 更新时间
     */
    @Column(name = "update_time")
    private Date updateTime;
    /**
     * 更新人id
     */
    @Column(name = "update_user_id")
    private String updateUserId;


    public static RbacCustomRoleUserEntity create(Long id, String organizationId, Long rbacRoleId, String tenantEmployeeId, String createUserId) {
        RbacCustomRoleUserEntity role = new RbacCustomRoleUserEntity();
        role.setId(id);
        role.setOrganizationId(organizationId);
        role.setRbacRoleId(rbacRoleId);
        role.setTenantEmployeeId(tenantEmployeeId);
        role.setCreateTime(new Date());
        role.setCreateUserId(createUserId);
        return role;
    }
}
