package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

@Setter(AccessLevel.PROTECTED)
@Getter
@Table(name = "rbac_categories")
@Entity
public class CategoryEntity extends OpEntityAbstract implements IAggregate {
    @Id
    private String id;

    @Column(name = "code",length = 200,nullable = false)
    private String code;

    @Column(name = "name", length = 500, nullable = false)
    private String name;

    @Column(name = "note", length = 4000)
    private String note;

    @Column(name = "created_time")
    private Timestamp createdTime;

    @OneToMany(mappedBy = "category",cascade = CascadeType.ALL)
    private Collection<ResourceEntity> resources;

    public void change(String code, String name,String note) {
        this.setCode(code);
        this.setName(name);
        this.setNote(note);
    }

    public void assignResource(String id, String code, String name, String data, String dataType) {
        Collection<ResourceEntity> res = this.getResources();
        if (res == null) {
            res = new ArrayList<>();
        }

        Optional<ResourceEntity> selectedRceOptional = res.stream().filter(ii -> ii.getId().equals(id)).findFirst();
        ResourceEntity selectedRce = null;
        if (selectedRceOptional.isPresent()) {
            selectedRce = selectedRceOptional.get();
        } else {
            selectedRce = ResourceEntity.create(this, id, code, name, data, dataType);
            res.add(selectedRce);
        }
        selectedRce.change(code, name, data, dataType);

        this.setResources(res);
    }

    protected CategoryEntity() {
        this.createdTime = Timestamp.from(Instant.now());
    }

    public static CategoryEntity create(String id ,String code,String name,String note) {
        CategoryEntity category = new CategoryEntity();
        category.setId(id);
        category.change(code, name, note);

        return category;
    }

    public static CategoryEntity create(String code,String name,String note) {
        return create(UUIDUtil.getShortUuid(),code,name,note);
    }
}
