package com.bcxin.rbac.domain.dtos;

import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;

@Getter
public class RoleDetailDto {
    private final String id;
    private final String name;
    private final Collection<RoleSelectedResourceDto> resources = new ArrayList<>();

    public RoleDetailDto(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static RoleDetailDto create(String id, String name) {
        return new RoleDetailDto(id, name);
    }

    public void addSelectedResource(RoleSelectedResourceDto resourceDto) {
        this.getResources().add(resourceDto);
    }

    @Getter
    public static class RoleSelectedResourceDto {
        private final String id;
        private final String code;
        private final String name;
        private final String treePathId;
        private final Collection<RoleSelectedResourceDto> children = new ArrayList<>();


        public RoleSelectedResourceDto(String id, String code,
                           String name, String treePathId) {
            this.id = id;
            this.code = code;
            this.name = name;
            this.treePathId = treePathId;
        }

        public static RoleSelectedResourceDto create(String id, String code,
                                         String name, String treePathId) {
            return new RoleSelectedResourceDto(id, code, name, treePathId);
        }

        public void addChildResource(RoleSelectedResourceDto resourceDto)
        {
            this.getChildren().add(resourceDto);
        }
    }
}
