package com.bcxin.rbac.domain.components.dtos;

import lombok.Getter;

import java.util.Collection;

@Getter
public class ModuleMetaDto {
    private final String id;
    private final String appId;
    private final String name;
    private final String uri;
    private final Collection<ModuleMetaDto> children;

    public ModuleMetaDto(String id, String appId, String name, String uri,
                         Collection<ModuleMetaDto> children) {
        this.id = id;
        this.appId = appId;
        this.name = name;
        this.uri = uri;
        this.children = children;
    }

    public static ModuleMetaDto create(String id, String appId, String name, String uri,
                                       Collection<ModuleMetaDto> children) {
        return new ModuleMetaDto(id, appId, name, uri, children);
    }
}
