package com.bcxin.security.domains.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.util.Date;

@Table(name = "tlk_certificate")
@Entity
@Data
public class CertificateEntity extends EntityAbstract implements IAggregate {


    @Id
    private String id;

    /**
     * 姓名
     */
    @Column(name = "item_securityname")
    private String name;

    /**
     * 身份证号
     */
    @Column(name = "item_documentid")
    private String idNum;

    /**
     * 证书类型 1资格证 2等级证
     */
    @Column(name = "item_certificatetype")
    private String cerType;

    /**
     * 等级
     */
    @Column(name = "item_level")
    private String level;

    /**
     * 证书编号
     */
    @Column(name = "item_certificateno")
    private String cerNo;
    /**
     * 发证机关
     */
    @Column(name = "item_certificatefrom")
    private String cerFrom;
    /**
     * 发证日期
     */
    @Column(name = "item_certificatedate")
    private Date cerDate;

    /**
     * 状态
     */
    @Column(name = "item_status")
    private String status;



}
