package com.bcxin.security.domains.configs;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @author linqinglin
 * @date 2022/1/14 9:53
 */
@Component
@ConfigurationProperties(prefix = "tenant.config.upload")
public class PlatformUploadConfig {

    private static String path;

    public static String getPath() {
        return path;
    }

    public void setPath(String path) {
        PlatformUploadConfig.path = path;
    }


    /**
     * 获取下载路径
     */
    public static String getDownloadPath()
    {

        if(getPath().endsWith("/")) {
            return getPath() + "uploads/download/";
        }
        return getPath() + "/uploads/download/";
    }
}
