package com.bcxin.identity.domain.repositories.impls;

import com.bcxin.identity.domains.entities.ToCOAuthSubjectPrincipalEntity;
import com.bcxin.identity.domains.enums.COAuthType;
import com.bcxin.identity.domains.repositories.ToCOAuthSubjectPrincipalRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;

@Repository
public interface ToCOAuthSubjectPrincipalJdbcRepository extends ToCOAuthSubjectPrincipalRepository,
        JpaRepository<ToCOAuthSubjectPrincipalEntity,String> {

    @Query("select u from ToCOAuthSubjectPrincipalEntity u where u.coAuthType=?1 and u.unionId=?2 and u.openId=?3")
    ToCOAuthSubjectPrincipalEntity getByUnionIdAndOpenId(COAuthType coAuthType, String unionId, String openId);

    @Query("select u from ToCOAuthSubjectPrincipalEntity u where u.coAuthType=?1 and u.unionId=?2 ")
    Collection<ToCOAuthSubjectPrincipalEntity> findSubjectsByUnionId(COAuthType coAuthType, String unionId);
}
