package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.XlcpEntity;
import com.bcxin.tenant.domain.repositories.XlcpRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;
import java.util.Date;
import java.util.List;

public interface XlcpJpaRepository extends XlcpRepository, JpaRepository<XlcpEntity,String> {

    @Query("select c from XlcpEntity c where c.organizationId=?1 and c.id=?2")
    XlcpEntity getByOrganIdAndId(String organizationId, String id);

    @Query("select c from XlcpEntity c where c.organizationId=?1 and c.employeeId=?2 order by c.creator.createdTime desc")
    List<XlcpEntity> getByOrganIdAndEmployeeId(String organizationId, String employeeId);

    @Query("select c from XlcpEntity c where c.organizationId=?1 and c.id in(?2)")
    List<XlcpEntity> getByOrganIdAndIds(String organizationId, List<String> ids);

    @Query("select c from XlcpEntity c where c.organizationId=?1 and c.employeeId=?2 order by c.creator.createdTime desc")
    List<XlcpEntity> findByOrganIdAndEmployeeId(String organizationId, String employeeId);
    @Query("select c from XlcpEntity c where c.employeeId=?1 and c.projectName=?2 order by c.creator.createdTime desc")
    Collection<XlcpEntity> findByEmployeeIdAndProjectName(String employeeId, String projectName);
    @Query("select c from XlcpEntity c where c.creator.createdTime > ?1 and c.fileUrl like ?2 order by c.creator.createdTime desc")
    Collection<XlcpEntity> findByTimeAndLikeName(Date lastTime, String keyword);

    @Query("select c from XlcpEntity c where c.employeeId=?1 and c.creator.createdTime > ?2 order by c.creator.createdTime desc")
    List<XlcpEntity> countWithinTheDeadlineOfEmployeeId(String organizationId, Date lastTime);

    @Query("select c from XlcpEntity c where c.serialNumber=?1")
    XlcpEntity getBySerialNumber(String serialNumber);
}
