package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.enums.EventProcessedStatus;
import com.bcxin.tenant.domain.repositories.TenantEventRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import java.util.Collection;
import java.util.Optional;

public interface TenantEventJpaRepository extends TenantEventRepository, JpaRepository<TenantEventEntity,String> {

    @Query(value = "select t from TenantEventEntity t where t.eventAction in (com.bcxin.tenant.domain.enums.EventAction.OrganizationCreated,com.bcxin.tenant.domain.enums.EventAction.OrganizationEdited,com.bcxin.tenant.domain.enums.EventAction.OrganizationEdited) and t.eventAction= ?1")
    Collection<TenantEventEntity> getPendingOrganEvents(EventProcessedStatus status);

    @Query(value = "select t from TenantEventEntity t where t.eventAction in (com.bcxin.tenant.domain.enums.EventAction.DepartmentDeleted,com.bcxin.tenant.domain.enums.EventAction.DepartmentCreated,com.bcxin.tenant.domain.enums.EventAction.DepartmentEdited) and t.status= ?1")
    Collection<TenantEventEntity> getPendingDepartEvents(EventProcessedStatus status);

    @Query(value = "select t from TenantEventEntity t where t.eventAction in (com.bcxin.tenant.domain.enums.EventAction.EmployeeDeleted,com.bcxin.tenant.domain.enums.EventAction.EmployeeCreated,com.bcxin.tenant.domain.enums.EventAction.EmployeeEdited) and t.status= ?1")
    Collection<TenantEventEntity> getPendingEmployeeEvents(EventProcessedStatus status);

    @Query("select t from TenantEventEntity t where t.version>=?1 and t.mapKey in (?2)")
    Collection<TenantEventEntity> getEvents(Long startVersion, Collection<String> mapKeys);

    @Query("select t from TenantEventEntity t where t.content=?1 and t.status=com.bcxin.tenant.domain.enums.EventProcessedStatus.Init")
    Collection<TenantEventEntity> getEventsByUserId(String tenantUserId);

    @Query("select t from TenantEventEntity t where t.content=?1 and t.eventAction=?2 and t.status in (com.bcxin.tenant.domain.enums.EventProcessedStatus.Init,com.bcxin.tenant.domain.enums.EventProcessedStatus.Processed)")
    Optional<TenantEventEntity> getPendingByContent(String content, EventAction action);

    @Query("select t from TenantEventEntity t where t.content=?1")
    Optional<TenantEventEntity> getByContent(String content);

    @Query("select t from TenantEventEntity t where t.content=?1 and t.status=com.bcxin.tenant.domain.enums.EventProcessedStatus.Init")
    Optional<TenantEventEntity> getByUserId(String tenantUserId);

    @Query("select t from TenantEventEntity t where t.content=?1 and t.eventAction=?2 and t.status=com.bcxin.tenant.domain.enums.EventProcessedStatus.Init")
    Collection<TenantEventEntity> getByUserIdAndAction(String tenantUserId, EventAction action);
}
