package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.OrganizationStatisticsReportEntity;
import com.bcxin.tenant.domain.repositories.OrganizationStatisticsReportsRepository;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationStatisticsDto;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;

public interface OrganizationStatisticsReportsJpaRepository extends OrganizationStatisticsReportsRepository, JpaRepository<OrganizationStatisticsReportEntity,String> {

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.OrganizationStatisticsDto(c.id,c.unifySocialCreditCode,count(e)) " +
            " from CompanyEntity c left join EmployeeEntity e on c.id = e.organization.id " +
            " where c.id in ?1 and e.status = 0" +
            " group by c.id"
    )
    Collection<OrganizationStatisticsDto> getOrganizationStatisticsInfo(Collection<String> orgIds);
}
