package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.DepartmentEmployeeRelationEntity;
import com.bcxin.tenant.domain.repositories.DepartmentEmployeeRelationRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface DepartmentEmployeeRelationJpaRepository extends DepartmentEmployeeRelationRepository, JpaRepository<DepartmentEmployeeRelationEntity, String> {

    @Query("select t from DepartmentEmployeeRelationEntity t where t.department.id = ?1 and t.employee.id in (?2) ")
    List<DepartmentEmployeeRelationEntity> findListByDepartmentIdAndEmployeeIds(String departmentId, List<String> employeeIds);

    @Modifying
    @Query("update DepartmentEmployeeRelationEntity t set t.leaderType = false where t.department.id = ?1 ")
    int updateLeaderTypeFalseByDepartmentId(String departmentId);

    @Modifying
    @Query("update DepartmentEmployeeRelationEntity t set t.leaderType = true where t.department.id = ?1 and t.employee.id in (?2) ")
    int updateLeaderTypeTrueByDepartmentIdAndEmployeeIds(String departmentId, List<String> employeeIds);
}
