package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.ContractEntity;
import com.bcxin.tenant.domain.repositories.ContractRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface ContractJpaRepository extends ContractRepository, JpaRepository<ContractEntity,String> {

    @Query("select c from ContractEntity c where c.organization.id=?1 and c.id=?2")
    ContractEntity getByOrganIdAndId(String organizationId, String id);

    @Query("select c from ContractEntity c where c.organization.id=?1 and c.id in(?2)")
    List<ContractEntity> getByOrganIdAndIds(String organizationId, List<String> ids);

    @Query("select c from ContractEntity c where c.organization.id=?1 and c.employee.id=?2")
    List<ContractEntity> getByOrganIdAndEmployeeId(String organizationId, String employeeId);

    @Query("select c from ContractEntity c where c.organization.id=?1 and c.employee.id in(?2)")
    List<ContractEntity> getByOrganIdAndEmployeeIds(String organizationId, List<String> employeeIds);
}
